/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public abstract class IOUtils {
    public static void deleteFilesRecursively(File root, final boolean deleteRoot) throws IOException {
        final Path rootPath = root.toPath();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (deleteRoot || !dir.equals(rootPath)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static byte[] readStreamFully(InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = stream.read(buffer)) >= 0) {
            data.write(buffer, 0, read);
        }
        data.flush();
        return data.toByteArray();
    }

    public static String readFileToString(File file) throws IOException {
        char[] chars = new char[2048];
        StringBuilder sb = new StringBuilder();
        try (FileReader reader = new FileReader(file);){
            int read = reader.read(chars);
            while (read >= 0) {
                sb.append(chars, 0, read);
                read = reader.read(chars);
            }
        }
        return sb.toString();
    }
}

