/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.util.Collection;
import java.util.Iterator;
import prompto.expression.IExpression;
import prompto.intrinsic.IterableWithCounts;
import prompto.runtime.Context;
import prompto.value.IValue;

public class IValueIterable<T>
implements IterableWithCounts<IValue> {
    Context context;
    Collection<T> iterable;

    public IValueIterable(Context context, Collection<T> iterable) {
        this.context = context;
        this.iterable = iterable;
    }

    @Override
    public Long getCount() {
        return this.iterable.size();
    }

    @Override
    public Long getTotalCount() {
        return this.iterable.size();
    }

    @Override
    public Iterator<IValue> iterator() {
        return new Iterator<IValue>(){
            Iterator<T> iterator;
            {
                this.iterator = IValueIterable.this.iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public IValue next() {
                try {
                    Object value = this.iterator.next();
                    if (value instanceof IExpression) {
                        value = ((IExpression)value).interpret(IValueIterable.this.context);
                    }
                    if (value instanceof IValue) {
                        return (IValue)value;
                    }
                    throw new InternalError("Item not a value!");
                }
                catch (Throwable t) {
                    throw new InternalError(t.getMessage());
                }
            }

            @Override
            public void remove() {
                throw new InternalError("Should never get there");
            }
        };
    }
}

