/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class Logger {
    org.slf4j.Logger logger;

    public Logger() {
        StackTraceElement elem = new Throwable().getStackTrace()[1];
        this.logger = LoggerFactory.getLogger((String)elem.getClassName());
    }

    public String getLoggedClass() {
        return this.logger.getName();
    }

    public void info(Supplier<String> message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message.get());
        }
    }

    public void debug(Supplier<String> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message.get());
        }
    }

    public void debug(Supplier<String> message, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message.get(), t);
        }
    }

    public void trace(Supplier<String> message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message.get());
        }
    }

    public void trace(Supplier<String> message, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message.get(), t);
        }
    }

    public void warn(Supplier<String> message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message.get());
        }
    }

    public void warn(Supplier<String> message, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message.get(), t);
        }
    }

    public void error(Supplier<String> message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.get());
        }
    }

    public void error(Supplier<String> message, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message.get(), t);
        }
    }
}

