/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ObjectUtils {
    public static <T> T downcast(Class<T> klass, Object actual) {
        if (actual != null && klass.isAssignableFrom(actual.getClass())) {
            return (T)actual;
        }
        return null;
    }

    public static Set<Class<?>> getClassesInCallStack() {
        return Stream.of(new Throwable().getStackTrace()).map(StackTraceElement::getClassName).filter(s -> s.indexOf("$Lambda$") < 0).map(n -> {
            try {
                return Class.forName(n);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    public static int safeCompare(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        throw new RuntimeException("Not a comparable object:" + a);
    }
}

