/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ResourceUtils {
    static Map<String, ResourceLister> protocolResourceListers = new HashMap<String, ResourceLister>();
    static final Set<String> promptoExtensions;

    public static Collection<URL> listResourcesAt(String path, Predicate<String> filter) throws IOException {
        Collection<URL> names;
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null && "/".equals(path)) {
            url = ResourceUtils.getRootURL();
        }
        if ((names = ResourceUtils.listResourcesAt(url, filter)) == null && url.toExternalForm().contains("/test-classes/")) {
            url = new URL(url.toExternalForm().replace("/test-classes/", "/classes/"));
            names = ResourceUtils.listResourcesAt(url, filter);
        }
        return names;
    }

    public static void registerResourceLister(String protocol, ResourceLister lister) {
        protocolResourceListers.put(protocol, lister);
    }

    public static Collection<URL> listResourcesAt(URL url, Predicate<String> filter) throws IOException {
        ResourceLister lister = protocolResourceListers.get(url.getProtocol());
        if (lister == null) {
            throw new UnsupportedOperationException("protocol:" + url.getProtocol());
        }
        return lister.listResourcesAt(url, filter);
    }

    private static URL getRootURL() throws IOException {
        try {
            return ClassLoader.getSystemClassLoader().getResource(".");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Collection<URL> listFileResourcesAt(URL url, Predicate<String> filter) throws IOException {
        try {
            File dir = new File(url.toURI());
            if (!dir.exists()) {
                return null;
            }
            String[] names = dir.list();
            Stream<Object> stream = Arrays.asList(names).stream();
            if (filter != null) {
                stream = stream.filter(filter);
            }
            return stream.map(name -> {
                try {
                    return new File(dir, (String)name).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static Collection<URL> listJarResourcesAt(URL url, Predicate<String> filter) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        JarURLConnection cnx = (JarURLConnection)url.openConnection();
        JarFile jar = cnx.getJarFile();
        String external = url.toExternalForm();
        String jarPart = external.substring(0, external.indexOf("!/") + 2);
        String pathPart = external.substring(jarPart.length());
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(pathPart) || name.endsWith("/") || filter != null && !filter.test(name)) continue;
            urls.add(new URL(jarPart + name));
        }
        return urls;
    }

    public static byte[] getResourceAsBytes(String path) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        return ResourceUtils.getResourceAsBytes(url);
    }

    public static byte[] getResourceAsBytes(URL url) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ResourceUtils.copyResourceToStream(url, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String getResourceAsString(String path) throws IOException {
        byte[] bytes = ResourceUtils.getResourceAsBytes(path);
        return bytes == null ? null : new String(bytes);
    }

    public static boolean isPromptoLibrary(String name) {
        int pos = name.lastIndexOf(".");
        return pos < 0 ? false : promptoExtensions.contains(name.substring(pos + 1));
    }

    public static void copyResourceToFile(URL url, Path target) throws IOException {
        try (FileOutputStream output = new FileOutputStream(target.toFile());){
            ResourceUtils.copyResourceToStream(url, output);
        }
    }

    public static void copyResourceToStream(URL url, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        try (InputStream input = url.openStream();){
            int read;
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
            output.flush();
        }
    }

    static {
        ResourceUtils.registerResourceLister("jar", ResourceUtils::listJarResourcesAt);
        ResourceUtils.registerResourceLister("file", ResourceUtils::listFileResourcesAt);
        promptoExtensions = new HashSet<String>(Arrays.asList("pec", "poc", "pmc", "pes", "pos", "pms"));
    }

    public static interface ResourceLister {
        public Collection<URL> listResourcesAt(URL var1, Predicate<String> var2) throws IOException;
    }
}

