/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class ThreadUtils {
    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup result = Thread.currentThread().getThreadGroup();
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    public static ThreadGroup[] getAllThreadGroups() {
        ThreadGroup[] groups;
        ThreadGroup root = ThreadUtils.getRootThreadGroup();
        int count = root.activeGroupCount();
        while ((count = root.enumerate(groups = new ThreadGroup[count * 2], true)) == groups.length) {
        }
        ThreadGroup[] result = new ThreadGroup[count + 1];
        result[0] = root;
        System.arraycopy(groups, 0, result, 1, count);
        return result;
    }

    public static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = ThreadUtils.getRootThreadGroup();
        long count = ManagementFactory.getThreadMXBean().getTotalStartedThreadCount();
        while ((count = (long)root.enumerate(threads = new Thread[(int)count * 2], true)) == (long)threads.length) {
        }
        Thread[] result = new Thread[(int)count];
        System.arraycopy(threads, 0, result, 0, (int)count);
        return result;
    }

    public static void removeThreadLocalForThread(Thread thread, ThreadLocal<?> local) throws Exception {
        Object threadLocals = ThreadUtils.getThreadLocalsForThread(thread);
        if (threadLocals != null) {
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Method method = threadLocalMapClass.getDeclaredMethod("remove", ThreadLocal.class);
            method.setAccessible(true);
            method.invoke(threadLocals, local);
        }
    }

    private static Object getThreadLocalsForThread(Thread thread) throws Exception {
        Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
        threadLocalsField.setAccessible(true);
        return threadLocalsField.get(thread);
    }
}

