/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import prompto.declaration.CategoryDeclaration;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoPeriod;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Context;
import prompto.type.AnyType;
import prompto.type.BooleanType;
import prompto.type.CategoryType;
import prompto.type.CharacterType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.DecimalType;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.MissingType;
import prompto.type.NativeType;
import prompto.type.NullType;
import prompto.type.PeriodType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.UuidType;
import prompto.type.VersionType;
import prompto.type.VoidType;
import prompto.utils.ExpressionList;
import prompto.value.IValue;

public abstract class TypeUtils {
    static final Map<Type, IType> typeToITypeMap = TypeUtils.createTypeToITypeMap();

    public static IType inferValuesType(Context context, Collection<? extends IValue> items) {
        Collection<IType> types = TypeUtils.collectElementTypes(context, items);
        return TypeUtils.inferCollectionType(context, types);
    }

    public static Collection<IType> collectElementTypes(Context context, Collection<? extends IValue> items) {
        ArrayList<IType> types = new ArrayList<IType>(items.size());
        for (IValue iValue : items) {
            types.add(iValue.getType());
        }
        return types;
    }

    public static IType inferCollectionType(Context context, Collection<IType> types) {
        if (types.isEmpty()) {
            return MissingType.instance();
        }
        IType lastType = null;
        for (IType type : types) {
            if (lastType == null || lastType == NullType.instance()) {
                lastType = type;
                continue;
            }
            if (lastType.equals(type) || lastType.isAssignableFrom(context, type)) continue;
            if (type.isAssignableFrom(context, lastType)) {
                lastType = type;
                continue;
            }
            IType common = TypeUtils.inferCommonRootType(context, lastType, type);
            if (common != null) {
                lastType = common;
                continue;
            }
            throw new SyntaxError("Incompatible types: " + type.toString() + " and " + lastType.toString());
        }
        return lastType;
    }

    public static IType inferCommonRootType(Context context, IType type1, IType type2) {
        if (type1 instanceof CategoryType && type2 instanceof CategoryType) {
            return TypeUtils.inferCommonRootType(context, (CategoryType)type1, (CategoryType)type2, true);
        }
        if (type1 instanceof NativeType || type2 instanceof NativeType) {
            return AnyType.instance();
        }
        return null;
    }

    public static IType inferCommonRootType(Context context, CategoryType type1, CategoryType type2, boolean trySwap) {
        CategoryDeclaration decl1 = context.getRegisteredDeclaration(CategoryDeclaration.class, type1.getTypeNameId());
        if (decl1.getDerivedFrom() != null) {
            CategoryType parentType;
            for (Identifier id : decl1.getDerivedFrom()) {
                parentType = new CategoryType(id);
                if (!parentType.isAssignableFrom(context, type2)) continue;
                return parentType;
            }
            for (Identifier id : decl1.getDerivedFrom()) {
                parentType = new CategoryType(id);
                IType commonType = TypeUtils.inferCommonRootType(context, parentType, type2);
                if (commonType == null) continue;
                return commonType;
            }
        }
        if (trySwap) {
            return TypeUtils.inferCommonRootType(context, type2, type1, false);
        }
        return null;
    }

    public static IType inferElementType(Context context, ExpressionList expressions) {
        Collection<IType> types = TypeUtils.collectElementTypes(context, expressions);
        return TypeUtils.inferCollectionType(context, types);
    }

    private static Collection<IType> collectElementTypes(Context context, ExpressionList expressions) {
        ArrayList<IType> types = new ArrayList<IType>(expressions.size());
        for (IExpression expression : expressions) {
            types.add(expression.check(context));
        }
        return types;
    }

    static Map<Type, IType> createTypeToITypeMap() {
        HashMap<Type, IType> map = new HashMap<Type, IType>();
        map.put(Void.TYPE, VoidType.instance());
        map.put(Boolean.TYPE, BooleanType.instance());
        map.put((Type)((Object)Boolean.class), BooleanType.instance());
        map.put(Character.TYPE, CharacterType.instance());
        map.put((Type)((Object)Character.class), CharacterType.instance());
        map.put(Integer.TYPE, IntegerType.instance());
        map.put((Type)((Object)Integer.class), IntegerType.instance());
        map.put(Long.TYPE, IntegerType.instance());
        map.put((Type)((Object)Long.class), IntegerType.instance());
        map.put(Double.TYPE, DecimalType.instance());
        map.put((Type)((Object)Double.class), DecimalType.instance());
        map.put((Type)((Object)String.class), TextType.instance());
        map.put((Type)((Object)UUID.class), UuidType.instance());
        map.put((Type)((Object)PromptoDate.class), DateType.instance());
        map.put((Type)((Object)PromptoTime.class), TimeType.instance());
        map.put((Type)((Object)PromptoDateTime.class), DateTimeType.instance());
        map.put((Type)((Object)PromptoPeriod.class), PeriodType.instance());
        map.put((Type)((Object)PromptoVersion.class), VersionType.instance());
        map.put((Type)((Object)PromptoDocument.class), DocumentType.instance());
        map.put((Type)((Object)Object.class), AnyType.instance());
        return map;
    }

    public static IType typeToIType(Type type) {
        return typeToITypeMap.get(type);
    }
}

