/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoBinary;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.utils.ResourceUtils;
import prompto.value.BaseValue;
import prompto.value.BlobValue;
import prompto.value.IValue;
import prompto.value.ImageValue;
import prompto.value.TextValue;

public abstract class BinaryValue
extends BaseValue {
    PromptoBinary data;
    static Map<String, String> extensionToMimeType = new HashMap<String, String>();
    static Map<String, Set<String>> mimeTypeToExtensions = new HashMap<String, Set<String>>();

    public static BinaryValue fromURL(URL url) throws IOException {
        String ext = url.toExternalForm();
        ext = ext.substring(ext.lastIndexOf(46) + 1);
        String mimeType = BinaryValue.fileExtensionToMimeType(ext);
        byte[] bytes = ResourceUtils.getResourceAsBytes(url);
        return BinaryValue.newInstance(new PromptoBinary(mimeType, bytes));
    }

    public static BinaryValue newInstance(PromptoBinary data) {
        if (data.getMimeType().startsWith("image/")) {
            return new ImageValue(data);
        }
        return new BlobValue(data);
    }

    protected BinaryValue(IType type) {
        super(type);
    }

    protected BinaryValue(IType type, PromptoBinary data) {
        super(type);
        this.data = data;
    }

    @Override
    public PromptoBinary getStorableData() {
        return this.data;
    }

    public String getMimeType() {
        return this.data.getMimeType();
    }

    public byte[] getBytes() {
        return this.data.getBytes();
    }

    public PromptoBinary getData() {
        return this.data;
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
        String name = id.toString();
        if ("mimeType".equals(name)) {
            return new TextValue(this.data.getMimeType());
        }
        return super.getMember(context, id, autoCreate);
    }

    public static String fileExtensionToMimeType(String ext) {
        String mimeType = extensionToMimeType.get(ext.toLowerCase());
        if (mimeType == null) {
            return "application/octet-stream";
        }
        return mimeType;
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> binaries) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeStringField("type", this.getType().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeStartObject();
            generator.writeStringField("mimeType", this.getMimeType());
            generator.writeFieldName("url");
            if (binaries == null) {
                generator.writeString("/ws/bin/data?dbId=" + instanceId + "&attribute=" + fieldName.toString());
            } else {
                String partId = "@" + instanceId + '/' + fieldName + '/' + this.getMimeType().replace('/', '.');
                generator.writeString(partId);
                binaries.put(partId, this.getBytes());
            }
            generator.writeEndObject();
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    static {
        try {
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("mimeTypes.json");
            JsonNode node = new ObjectMapper().readTree(input);
            for (JsonNode mimeTypeNode : node) {
                String mimeType = mimeTypeNode.get("mimeType").asText();
                Set<String> extensionsSet = mimeTypeToExtensions.get(mimeType);
                if (extensionsSet == null) {
                    extensionsSet = new HashSet<String>();
                    mimeTypeToExtensions.put(mimeType, extensionsSet);
                }
                for (JsonNode extensionNode : mimeTypeNode.get("extensions")) {
                    String extension = extensionNode.asText();
                    extensionToMimeType.put(extension, mimeType);
                    extensionsSet.add(extension);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

