/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.runtime.Context;
import prompto.type.BooleanType;
import prompto.value.BaseValue;
import prompto.value.IValue;

public class BooleanValue
extends BaseValue
implements Comparable<BooleanValue> {
    public static BooleanValue TRUE = new BooleanValue(true);
    public static BooleanValue FALSE;
    boolean value;
    BooleanValue not;

    public static BooleanValue parse(String text) {
        return BooleanValue.valueOf(Boolean.parseBoolean(text));
    }

    public static BooleanValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    private BooleanValue(boolean value) {
        super(BooleanType.instance());
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    public BooleanValue getNot() {
        return this.not;
    }

    @Override
    public Object getStorableData() {
        return this.value;
    }

    @Override
    public int compareTo(Context context, IValue value) {
        if (value instanceof BooleanValue) {
            return this.compareTo((BooleanValue)value);
        }
        throw new SyntaxError("Illegal comparison: Boolean + " + value.getClass().getSimpleName());
    }

    @Override
    public int compareTo(BooleanValue other) {
        return Boolean.compare(this.value, other.value);
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return this.value;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanValue) {
            return this.value == ((BooleanValue)obj).value;
        }
        return false;
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.booleanNode(this.value);
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            generator.writeBoolean(this.value);
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    static {
        BooleanValue.TRUE.not = FALSE = new BooleanValue(false);
        BooleanValue.FALSE.not = TRUE;
    }
}

