/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import prompto.intrinsic.PromptoRange;
import prompto.type.CharacterType;
import prompto.value.CharacterValue;
import prompto.value.RangeBase;

public class CharacterRange
extends RangeBase<CharacterValue> {
    public CharacterRange(CharacterValue left, CharacterValue right) {
        this(new PromptoCharacterRange(left, right));
    }

    public CharacterRange(PromptoRange<CharacterValue> range) {
        super(CharacterType.instance(), range);
    }

    @Override
    public RangeBase<CharacterValue> newInstance(PromptoRange<CharacterValue> range) {
        return new CharacterRange(range);
    }

    static class PromptoCharacterRange
    extends PromptoRange<CharacterValue> {
        public PromptoCharacterRange(CharacterValue low, CharacterValue high) {
            super(low, high);
        }

        @Override
        public CharacterValue getItem(long item) {
            char result = (char)((long)((CharacterValue)this.low).getValue() + item - 1L);
            if (result > ((CharacterValue)this.high).getValue()) {
                throw new IndexOutOfBoundsException();
            }
            return new CharacterValue(result);
        }

        public PromptoCharacterRange slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new PromptoCharacterRange(this.getItem(first), this.getItem(last));
        }

        @Override
        public long getNativeCount() {
            return 1L + (long)((CharacterValue)this.high).getValue() - (long)((CharacterValue)this.low).getValue();
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof CharacterValue)) {
                return false;
            }
            CharacterValue other = (CharacterValue)item;
            return other.compareTo((CharacterValue)this.low) >= 0 && ((CharacterValue)this.high).compareTo(other) >= 0;
        }
    }
}

