/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.Collator;
import java.util.Map;
import java.util.function.Function;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoChar;
import prompto.runtime.Context;
import prompto.type.CharacterType;
import prompto.value.BaseValue;
import prompto.value.IMultiplyable;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.TextValue;

public class CharacterValue
extends BaseValue
implements Comparable<CharacterValue>,
IMultiplyable {
    char value;

    public CharacterValue(char value) {
        super(CharacterType.instance());
        this.value = value;
    }

    public char getValue() {
        return this.value;
    }

    @Override
    public Object getStorableData() {
        return Character.valueOf(this.value);
    }

    public IValue asText() {
        return new TextValue(Character.toString(this.value));
    }

    @Override
    public IValue plus(Context context, IValue value) {
        return new TextValue(this.value + value.toString());
    }

    @Override
    public IValue multiply(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            int count = (int)((IntegerValue)value).longValue();
            if (count < 0) {
                throw new SyntaxError("Negative repeat count:" + count);
            }
            return new TextValue(PromptoChar.multiply(this.value, count));
        }
        throw new SyntaxError("Illegal: Chararacter * " + value.getClass().getSimpleName());
    }

    @Override
    public int compareTo(CharacterValue obj) {
        return Character.compare(this.value, obj.value);
    }

    @Override
    public int compareTo(Context context, IValue value) {
        if (value instanceof CharacterValue) {
            return Character.compare(this.value, ((CharacterValue)value).value);
        }
        throw new SyntaxError("Illegal comparison: Character + " + value.getClass().getSimpleName());
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
        if ("codePoint".equals(id.toString())) {
            return new IntegerValue(this.value);
        }
        return super.getMember(context, id, autoCreate);
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return Character.valueOf(this.value);
    }

    public String toString() {
        return "" + this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharacterValue) {
            return this.value == ((CharacterValue)obj).value;
        }
        return false;
    }

    @Override
    public boolean roughly(Context context, IValue obj) throws PromptoError {
        if (obj instanceof CharacterValue || obj instanceof TextValue) {
            Collator c = Collator.getInstance();
            c.setStrength(0);
            return c.compare(Character.valueOf(this.value), (Object)obj.toString()) == 0;
        }
        return false;
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.textNode(String.valueOf(this.value));
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(CharacterType.instance().getTypeName());
                generator.writeFieldName("value");
                generator.writeString("" + this.value);
                generator.writeEndObject();
            } else {
                generator.writeString("" + this.value);
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }
}

