/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import java.lang.reflect.Type;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.value.BaseValue;
import prompto.value.IValue;

public class ClosureValue
extends BaseValue {
    Context context;

    public ClosureValue(Context context, MethodType type) {
        super(type);
        this.context = context;
    }

    @Override
    public Object convertTo(Context context, Type type) {
        if (type == IMethodDeclaration.class) {
            return this.getMethod();
        }
        return super.convertTo(context, type);
    }

    private IMethodDeclaration getMethod() {
        return ((MethodType)this.type).getMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue interpret(Context context) throws PromptoError {
        Context parentMost = this.context.getParentMostContext();
        Context savedParent = parentMost.getParentContext();
        parentMost.setParentContext(context);
        Context local = this.context.newChildContext();
        try {
            IValue iValue = this.doInterpret(local);
            return iValue;
        }
        finally {
            parentMost.setParentContext(savedParent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue doInterpret(Context local) {
        IMethodDeclaration declaration = this.getMethod();
        local.enterMethod(declaration);
        try {
            IValue iValue = declaration.interpret(local);
            return iValue;
        }
        finally {
            local.leaveSection(declaration);
        }
    }

    public Identifier getName() {
        return this.getMethod().getId();
    }

    public ParameterList getArguments() {
        return this.getMethod().getParameters();
    }

    public IType getReturnType() {
        return this.getMethod().getReturnType();
    }
}

