/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.EnumeratedCategoryDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.SetterMethodDeclaration;
import prompto.error.NotMutableError;
import prompto.error.NotStorableError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.grammar.Operator;
import prompto.intrinsic.PromptoDocument;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.store.DataStore;
import prompto.store.IStorable;
import prompto.type.CategoryType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.TextType;
import prompto.value.BaseValue;
import prompto.value.DbIdValue;
import prompto.value.DecimalValue;
import prompto.value.DocumentValue;
import prompto.value.IInstance;
import prompto.value.IMultiplyable;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.NativeInstance;
import prompto.value.NullValue;
import prompto.value.TextValue;

public class ConcreteInstance
extends BaseValue
implements IInstance,
IMultiplyable {
    CategoryDeclaration declaration;
    Map<Identifier, IValue> values = new HashMap<Identifier, IValue>();
    IStorable storable = null;
    boolean mutable = false;
    ThreadLocal<Map<Identifier, Context>> activeGetters = new ThreadLocal<Map<Identifier, Context>>(){

        @Override
        protected Map<Identifier, Context> initialValue() {
            return new HashMap<Identifier, Context>();
        }
    };
    ThreadLocal<Map<Identifier, Context>> activeSetters = new ThreadLocal<Map<Identifier, Context>>(){

        @Override
        protected Map<Identifier, Context> initialValue() {
            return new HashMap<Identifier, Context>();
        }
    };

    public ConcreteInstance(Context context, CategoryDeclaration declaration) {
        super(new CategoryType(declaration.getId()));
        this.declaration = declaration;
        if (declaration.isStorable(context)) {
            List<String> categories = declaration.collectCategories(context);
            this.storable = DataStore.getInstance().newStorable(categories, (IStorable.IDbIdFactory)new DbIdFactory());
        }
    }

    private ConcreteInstance(CategoryType copyFrom, CategoryDeclaration declaration, Map<Identifier, IValue> values, String[] categories) {
        super(new CategoryType(copyFrom, true));
        this.declaration = declaration;
        if (declaration.isStorable(null)) {
            this.storable = DataStore.getInstance().newStorable(categories, (IStorable.IDbIdFactory)new DbIdFactory());
        }
        this.values.putAll(values);
        this.mutable = true;
    }

    @Override
    public IValue toMutable() {
        String[] categories = this.storable != null ? this.storable.getCategories() : null;
        return new ConcreteInstance(this.getType(), this.declaration, this.values, categories);
    }

    @Override
    public Object getStorableData() throws NotStorableError {
        if (this.declaration instanceof EnumeratedCategoryDeclaration) {
            return this.values.get(new Identifier("name")).getStorableData();
        }
        if (this.storable == null) {
            throw new NotStorableError();
        }
        return this.getOrCreateDbId();
    }

    @Override
    public boolean setMutable(boolean mutable) {
        boolean result = this.mutable;
        this.mutable = mutable;
        return result;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public IStorable getStorable() {
        return this.storable;
    }

    @Override
    public void collectStorables(Consumer<IStorable> collector) {
        if (this.declaration instanceof EnumeratedCategoryDeclaration) {
            return;
        }
        if (this.storable == null) {
            throw new NotStorableError();
        }
        if (this.storable.isDirty()) {
            this.getOrCreateDbId();
            collector.accept(this.storable);
        }
        this.values.values().forEach(value -> value.collectStorables(collector));
    }

    @Override
    public CategoryDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public CategoryType getType() {
        return (CategoryType)this.type;
    }

    @Override
    public Set<Identifier> getMemberIds() {
        return this.values.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue getMember(Context context, Identifier attrName, boolean autoCreate) throws PromptoError {
        boolean first;
        if ("category".equals(attrName.toString())) {
            return this.getCategory(context);
        }
        Map<Identifier, Context> activeGetters = this.activeGetters.get();
        Context stacked = activeGetters.get(attrName);
        boolean bl = first = stacked == null;
        if (first) {
            activeGetters.put(attrName, context);
        }
        try {
            IValue iValue = this.getMemberAllowGetter(context, attrName, first);
            return iValue;
        }
        finally {
            if (first) {
                activeGetters.remove(attrName);
            }
        }
    }

    private IValue getCategory(Context context) {
        NativeCategoryDeclaration decl = context.getRegisteredDeclaration(NativeCategoryDeclaration.class, new Identifier("Category"));
        return new NativeInstance(decl, this.declaration);
    }

    protected IValue getMemberAllowGetter(Context context, Identifier attrName, boolean allowGetter) throws PromptoError {
        GetterMethodDeclaration getter;
        GetterMethodDeclaration getterMethodDeclaration = getter = allowGetter ? this.declaration.findGetter(context, attrName) : null;
        if (getter != null) {
            context = context.newInstanceContext(this, false).newChildContext();
            return getter.interpret(context);
        }
        if (this.getDeclaration().hasAttribute(context, attrName) || "dbId".equals(attrName.toString())) {
            return this.values.getOrDefault(attrName, NullValue.instance());
        }
        if ("text".equals(attrName.toString())) {
            return new TextValue(this.toString());
        }
        return NullValue.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMember(Context context, Identifier attrName, IValue value) throws PromptoError {
        if (!this.mutable) {
            throw new NotMutableError();
        }
        Map<Identifier, Context> activeSetters = this.activeSetters.get();
        Context stacked = activeSetters.get(attrName);
        boolean first = stacked == null;
        try {
            if (first) {
                activeSetters.put(attrName, context);
            }
            this.setMember(context, attrName, value, first);
        }
        finally {
            if (first) {
                activeSetters.remove(attrName);
            }
        }
    }

    public void setMember(Context context, Identifier attrName, IValue value, boolean allowSetter) throws PromptoError {
        SetterMethodDeclaration setter;
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, attrName);
        SetterMethodDeclaration setterMethodDeclaration = setter = allowSetter ? this.declaration.findSetter(context, attrName) : null;
        if (setter != null) {
            context = context.newInstanceContext(this, false).newChildContext();
            context.registerValue(new Variable(attrName, decl.getType()));
            context.setValue(attrName, value);
            value = setter.interpret(context);
        }
        value = this.autocast(decl, value);
        this.values.put(attrName, value);
        if (this.storable != null && decl.isStorable(context)) {
            this.storable.setData(attrName.toString(), value.getStorableData());
        }
    }

    private Object getDbId() {
        try {
            IValue dbId = this.values.get(new Identifier("dbId"));
            return dbId == null ? null : dbId.getStorableData();
        }
        catch (NotStorableError e) {
            throw new RuntimeException(e);
        }
    }

    private void setDbId(Object dbId) {
        DbIdValue value = new DbIdValue(dbId);
        this.values.put(new Identifier("dbId"), value);
    }

    private Object getOrCreateDbId() throws NotStorableError {
        Object dbId = this.getDbId();
        if (dbId == null) {
            dbId = this.storable.getOrCreateDbId();
            this.setDbId(dbId);
        }
        return dbId;
    }

    private IValue autocast(AttributeDeclaration decl, IValue value) {
        if (value != null && value instanceof IntegerValue && decl.getType() == DecimalType.instance()) {
            value = new DecimalValue(((IntegerValue)value).doubleValue());
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConcreteInstance)) {
            return false;
        }
        return this.values.equals(((ConcreteInstance)obj).values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<Identifier, IValue> kvp : this.values.entrySet()) {
            if ("dbId".equals(kvp.getKey().toString())) continue;
            sb.append(kvp.getKey().toString());
            sb.append(":");
            sb.append(kvp.getValue().toString());
            sb.append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public IValue multiply(Context context, IValue value) throws PromptoError {
        try {
            return this.interpretOperator(context, value, Operator.MULTIPLY);
        }
        catch (SyntaxError e) {
            return super.multiply(context, value);
        }
    }

    @Override
    public IValue divide(Context context, IValue value) throws PromptoError {
        try {
            return this.interpretOperator(context, value, Operator.DIVIDE);
        }
        catch (SyntaxError e) {
            return super.divide(context, value);
        }
    }

    @Override
    public IValue intDivide(Context context, IValue value) throws PromptoError {
        try {
            return this.interpretOperator(context, value, Operator.IDIVIDE);
        }
        catch (SyntaxError e) {
            return super.intDivide(context, value);
        }
    }

    @Override
    public IValue modulo(Context context, IValue value) throws PromptoError {
        try {
            return this.interpretOperator(context, value, Operator.MODULO);
        }
        catch (SyntaxError e) {
            return super.modulo(context, value);
        }
    }

    @Override
    public IValue plus(Context context, IValue value) throws PromptoError {
        try {
            return this.interpretOperator(context, value, Operator.PLUS);
        }
        catch (SyntaxError e) {
            return super.plus(context, value);
        }
    }

    @Override
    public IValue minus(Context context, IValue value) throws PromptoError {
        try {
            return this.interpretOperator(context, value, Operator.MINUS);
        }
        catch (SyntaxError e) {
            return super.minus(context, value);
        }
    }

    private IValue interpretOperator(Context context, IValue value, Operator operator) throws PromptoError {
        IMethodDeclaration decl = this.declaration.findOperator(context, operator, value.getType());
        context = context.newInstanceContext(this, false);
        Context local = context.newChildContext();
        decl.registerParameters(local);
        IParameter arg = (IParameter)decl.getParameters().getFirst();
        local.setValue(arg.getId(), value);
        return decl.interpret(local);
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<Identifier, IValue> entry : this.values.entrySet()) {
            result.set(entry.getKey().toString(), producer.apply(entry.getValue()));
        }
        return result;
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(this.getType().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeStartObject();
            for (Map.Entry<Identifier, IValue> entry : this.values.entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                IValue value = entry.getValue();
                if (value == null) {
                    generator.writeNull();
                    continue;
                }
                this.attributeToJson(context, generator, entry, withType, data);
            }
            generator.writeEndObject();
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    private void attributeToJson(Context context, JsonGenerator generator, Map.Entry<Identifier, IValue> entry, boolean withType, Map<String, byte[]> data) throws IOException {
        boolean wrap;
        Object id = this.getDbId();
        if (id == null) {
            id = System.identityHashCode(this);
        }
        IValue value = entry.getValue();
        IType type = value.getType();
        boolean bl = wrap = withType && "dbId".equals(entry.getKey().toString()) && (type == IntegerType.instance() || type == TextType.instance());
        if (wrap) {
            generator.writeStartObject();
            generator.writeFieldName("type");
            generator.writeString(value.getType().getTypeName());
            generator.writeFieldName("value");
        }
        value.toJsonStream(context, generator, id, entry.getKey().toString(), withType, data);
        if (wrap) {
            generator.writeEndObject();
        }
    }

    @Override
    public DocumentValue toDocumentValue(Context context) {
        PromptoDocument<Identifier, IValue> doc = new PromptoDocument<Identifier, IValue>();
        for (Map.Entry<Identifier, IValue> entry : this.values.entrySet()) {
            IValue value = entry.getValue();
            if (value == null) {
                value = NullValue.instance();
            }
            value = value.toDocumentValue(context);
            doc.put(entry.getKey(), value);
        }
        return new DocumentValue(context, doc, false);
    }

    class DbIdFactory
    implements IStorable.IDbIdFactory {
        DbIdFactory() {
        }

        @Override
        public Object get() {
            return ConcreteInstance.this.getDbId();
        }

        @Override
        public void accept(Object dbId) {
            ConcreteInstance.this.setDbId(dbId);
        }

        @Override
        public boolean isUpdate() {
            return true;
        }
    }
}

