/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoRange;
import prompto.type.DateType;
import prompto.value.DateValue;
import prompto.value.RangeBase;

public class DateRange
extends RangeBase<DateValue> {
    public DateRange(DateValue left, DateValue right) {
        this(new PromptoDateRange(left, right));
    }

    public DateRange(PromptoRange<DateValue> range) {
        super(DateType.instance(), range);
    }

    @Override
    public RangeBase<DateValue> newInstance(PromptoRange<DateValue> range) {
        return new DateRange(range);
    }

    static class PromptoDateRange
    extends PromptoRange<DateValue> {
        public PromptoDateRange(DateValue low, DateValue high) {
            super(low, high);
        }

        @Override
        public DateValue getItem(long item) {
            PromptoDate result = ((DateValue)this.low).value.plusDays(item - 1L);
            if (result.isAfter(((DateValue)this.high).value)) {
                throw new IndexOutOfBoundsException();
            }
            return new DateValue(result);
        }

        public PromptoDateRange slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new PromptoDateRange(this.getItem(first), this.getItem(last));
        }

        @Override
        public long getNativeCount() {
            long h = ((DateValue)this.high).value.toJavaTime();
            long l = ((DateValue)this.low).value.toJavaTime();
            return 1L + (h - l) / 86400000L;
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof DateValue)) {
                return false;
            }
            DateValue other = (DateValue)item;
            return other.compareTo((DateValue)this.low) >= 0 && ((DateValue)this.high).compareTo(other) >= 0;
        }
    }
}

