/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDateTime;
import prompto.runtime.Context;
import prompto.type.DateTimeType;
import prompto.value.BaseValue;
import prompto.value.DateValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.PeriodValue;
import prompto.value.TextValue;
import prompto.value.TimeValue;

public class DateTimeValue
extends BaseValue
implements Comparable<DateTimeValue> {
    PromptoDateTime value;

    public DateTimeValue(PromptoDateTime dt) {
        super(DateTimeType.instance());
        this.value = dt;
    }

    public DateTimeValue(int year, int month, int day, int hour, int minute, int second) {
        super(DateTimeType.instance());
        this.value = new PromptoDateTime(year, month, day, hour, minute, second, 0);
    }

    public DateTimeValue(int year, int month, int day, int hour, int minute, int second, int milli) {
        super(DateTimeType.instance());
        this.value = new PromptoDateTime(year, month, day, hour, minute, second, milli);
    }

    public DateTimeValue(String value) {
        super(DateTimeType.instance());
        this.value = PromptoDateTime.parse(value);
    }

    @Override
    public PromptoDateTime getStorableData() {
        return this.value;
    }

    @Override
    public IValue plus(Context context, IValue value) throws PromptoError {
        if (value instanceof PeriodValue) {
            return new DateTimeValue(this.value.plus(((PeriodValue)value).value));
        }
        throw new SyntaxError("Illegal: DateTime + " + value.getClass().getSimpleName());
    }

    @Override
    public IValue minus(Context context, IValue value) throws PromptoError {
        if (value instanceof DateTimeValue) {
            return new PeriodValue(this.value.minus(((DateTimeValue)value).value));
        }
        if (value instanceof PeriodValue) {
            return new DateTimeValue(this.value.minus(((PeriodValue)value).value));
        }
        throw new SyntaxError("Illegal: DateTime - " + value.getClass().getSimpleName());
    }

    @Override
    public int compareTo(Context context, IValue value) throws PromptoError {
        if (value instanceof DateTimeValue) {
            return this.value.compareTo(((DateTimeValue)value).value);
        }
        throw new SyntaxError("Illegal comparison: DateTime + " + value.getClass().getSimpleName());
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
        String name = id.toString();
        if ("year".equals(name)) {
            return new IntegerValue(this.value.getYear());
        }
        if ("month".equals(name)) {
            return new IntegerValue(this.value.getNativeMonth());
        }
        if ("dayOfMonth".equals(name)) {
            return new IntegerValue(this.value.getNativeDayOfMonth());
        }
        if ("dayOfYear".equals(name)) {
            return new IntegerValue(this.value.getNativeDayOfYear());
        }
        if ("hour".equals(name)) {
            return new IntegerValue(this.value.getNativeHour());
        }
        if ("minute".equals(name)) {
            return new IntegerValue(this.value.getNativeMinute());
        }
        if ("second".equals(name)) {
            return new IntegerValue(this.value.getNativeSecond());
        }
        if ("millisecond".equals(name)) {
            return new IntegerValue(this.value.getNativeMillis());
        }
        if ("tzOffset".equals(name)) {
            return new IntegerValue(this.value.getNativeTzOffset());
        }
        if ("tzName".equals(name)) {
            return new TextValue(this.value.getTzName());
        }
        if ("date".equals(name)) {
            return new DateValue(this.value.getDate());
        }
        if ("time".equals(name)) {
            return new TimeValue(this.value.getTime());
        }
        return super.getMember(context, id, autoCreate);
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return this.value;
    }

    @Override
    public int compareTo(DateTimeValue other) {
        return this.value.compareTo(other.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateTimeValue) {
            return this.value.equals(((DateTimeValue)obj).value);
        }
        return this.value.equals(obj);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.textNode(this.toString());
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(DateTimeType.instance().getTypeName());
                generator.writeFieldName("value");
                generator.writeString(this.toString());
                generator.writeEndObject();
            } else {
                generator.writeString(this.toString());
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    @Override
    public IValue toDocumentValue(Context context) {
        return new TextValue(this.toString());
    }
}

