/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import prompto.error.DivideByZeroError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.runtime.Context;
import prompto.type.DecimalType;
import prompto.value.BaseValue;
import prompto.value.IMultiplyable;
import prompto.value.INumber;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class DecimalValue
extends BaseValue
implements INumber,
Comparable<INumber>,
IMultiplyable {
    double value;

    public static DecimalValue Parse(String text) {
        return new DecimalValue(Double.parseDouble(text));
    }

    public DecimalValue(double value) {
        super(DecimalType.instance());
        this.value = value;
    }

    @Override
    public Double getStorableData() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public IValue plus(Context context, IValue value) {
        if (value instanceof IntegerValue) {
            return new DecimalValue(this.value + (double)((IntegerValue)value).longValue());
        }
        if (value instanceof DecimalValue) {
            return new DecimalValue(this.value + ((DecimalValue)value).doubleValue());
        }
        throw new SyntaxError("Illegal: Decimal + " + value.getClass().getSimpleName());
    }

    @Override
    public IValue minus(Context context, IValue value) {
        if (value instanceof IntegerValue) {
            return new DecimalValue(this.value - (double)((IntegerValue)value).longValue());
        }
        if (value instanceof DecimalValue) {
            return new DecimalValue(this.value - ((DecimalValue)value).doubleValue());
        }
        throw new SyntaxError("Illegal: Decimal - " + value.getClass().getSimpleName());
    }

    @Override
    public IValue multiply(Context context, IValue value) {
        if (value instanceof IntegerValue) {
            return new DecimalValue(this.doubleValue() * (double)((IntegerValue)value).longValue());
        }
        if (value instanceof DecimalValue) {
            return new DecimalValue(this.doubleValue() * ((DecimalValue)value).doubleValue());
        }
        throw new SyntaxError("Illegal: Decimal * " + value.getClass().getSimpleName());
    }

    @Override
    public IValue divide(Context context, IValue value) throws PromptoError {
        if (value instanceof INumber) {
            if (((INumber)value).doubleValue() == 0.0) {
                throw new DivideByZeroError();
            }
            return new DecimalValue(this.doubleValue() / ((INumber)value).doubleValue());
        }
        throw new SyntaxError("Illegal: Decimal / " + value.getClass().getSimpleName());
    }

    @Override
    public IValue intDivide(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            if (((IntegerValue)value).longValue() == 0L) {
                throw new DivideByZeroError();
            }
            return new IntegerValue(this.longValue() / ((IntegerValue)value).longValue());
        }
        throw new SyntaxError("Illegal: Decimal \\ " + value.getClass().getSimpleName());
    }

    @Override
    public IValue modulo(Context context, IValue value) throws PromptoError {
        if (value instanceof INumber) {
            if (((INumber)value).doubleValue() == 0.0) {
                throw new DivideByZeroError();
            }
            return new DecimalValue(this.doubleValue() % ((INumber)value).doubleValue());
        }
        throw new SyntaxError("Illegal: Decimal % " + value.getClass().getSimpleName());
    }

    @Override
    public int compareTo(INumber obj) {
        return Double.compare(this.value, obj.doubleValue());
    }

    @Override
    public int compareTo(Context context, IValue value) throws PromptoError {
        if (value instanceof INumber) {
            return Double.compare(this.value, ((INumber)value).doubleValue());
        }
        throw new SyntaxError("Illegal comparison: Decimal and " + value.getClass().getSimpleName());
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return this.value;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerValue) {
            return this.value == (double)((IntegerValue)obj).value;
        }
        if (obj instanceof DecimalValue) {
            return this.value == ((DecimalValue)obj).value;
        }
        return false;
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.numberNode(this.value);
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            generator.writeNumber(this.value);
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    public IValue negate() {
        return new DecimalValue(-this.value);
    }
}

