/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoDict;
import prompto.intrinsic.PromptoSet;
import prompto.runtime.Context;
import prompto.store.InvalidValueError;
import prompto.type.ContainerType;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.TextType;
import prompto.value.BaseValue;
import prompto.value.IContainer;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.ListValue;
import prompto.value.NullValue;
import prompto.value.SetValue;
import prompto.value.TextValue;

public class DictionaryValue
extends BaseValue
implements IContainer<IValue> {
    PromptoDict<TextValue, IValue> dict;

    public DictionaryValue(IType itemType, boolean mutable) {
        super(new DictType(itemType));
        this.dict = new PromptoDict(mutable);
    }

    public DictionaryValue(DictionaryValue from) {
        this(((ContainerType)from.type).getItemType(), from.dict);
    }

    public DictionaryValue(IType itemType, PromptoDict<TextValue, IValue> dict) {
        super(new DictType(itemType));
        this.dict = dict;
    }

    @Override
    public PromptoDict<TextValue, IValue> getStorableData() {
        return this.dict;
    }

    public static DictionaryValue merge(DictionaryValue dict1, DictionaryValue dict2) {
        PromptoDict<TextValue, IValue> dict = new PromptoDict<TextValue, IValue>(false);
        dict.putAll(dict1.dict);
        dict.putAll(dict2.dict);
        return new DictionaryValue(((ContainerType)dict1.type).getItemType(), dict);
    }

    public DictionaryValue swap(Context context) {
        Identifier text = new Identifier("text");
        PromptoDict<TextValue, IValue> swapped = new PromptoDict<TextValue, IValue>(true);
        this.dict.forEach((k, v) -> {
            if (!(v instanceof TextValue)) {
                v = v.getMember(context, text, false);
            }
            swapped.put((TextValue)v, (IValue)k);
        });
        swapped.setMutable(false);
        return new DictionaryValue((IType)TextType.instance(), swapped);
    }

    @Override
    public long getLength() {
        return this.dict.size();
    }

    @Override
    public IValue plus(Context context, IValue value) throws PromptoError {
        if (value instanceof DictionaryValue) {
            return DictionaryValue.merge(this, (DictionaryValue)value);
        }
        throw new SyntaxError("Illegal: Dict + " + value.getClass().getSimpleName());
    }

    @Override
    public boolean hasItem(Context context, IValue value) {
        if (value instanceof TextValue) {
            return this.dict.containsKey((TextValue)value);
        }
        throw new SyntaxError("Only Text key supported by " + this.getClass().getSimpleName());
    }

    @Override
    public boolean isMutable() {
        return this.dict.isMutable();
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
        String name;
        switch (name = id.toString()) {
            case "count": {
                return new IntegerValue(this.dict.size());
            }
            case "keys": {
                return new SetValue(TextType.instance(), new PromptoSet<IValue>(this.dict.keySet()));
            }
            case "values": {
                return new ListValue(((ContainerType)this.type).getItemType(), this.dict.values());
            }
        }
        return super.getMember(context, id, autoCreate);
    }

    @Override
    public void setItem(Context context, IValue item, IValue value) {
        if (!(item instanceof TextValue)) {
            throw new InvalidValueError("Expected a Text, got:" + item.getClass().getName());
        }
        this.dict.put((TextValue)item, value);
    }

    @Override
    public IValue getItem(Context context, IValue index) throws PromptoError {
        return this.getItem(index);
    }

    public IValue getItem(IValue index) throws PromptoError {
        if (index instanceof TextValue) {
            return this.dict.getOrDefault((TextValue)index, NullValue.instance());
        }
        throw new SyntaxError("No such item:" + index.toString());
    }

    @Override
    public Object convertTo(Context context, Type type) {
        if (this.canConvertTo(type)) {
            Type itemType = this.getItemType(type);
            PromptoDict<String, Object> dict = new PromptoDict<String, Object>(true);
            for (Map.Entry entry : this.dict.entrySet()) {
                String key = ((TextValue)entry.getKey()).toString();
                Object value = ((IValue)entry.getValue()).convertTo(context, itemType);
                dict.put(key, value);
            }
            dict.setMutable(this.isMutable());
            return dict;
        }
        return super.convertTo(context, type);
    }

    private boolean canConvertTo(Type type) {
        return type == PromptoDict.class || type instanceof Class && ((Class)type).isAssignableFrom(PromptoDict.class);
    }

    private Type getItemType(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[1] : Object.class;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DictionaryValue)) {
            return false;
        }
        return this.dict.equals(((DictionaryValue)obj).dict);
    }

    public String toString() {
        return this.dict.toString();
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : this.dict.entrySet()) {
            result.set(((TextValue)entry.getKey()).getStorableData(), producer.apply((IValue)entry.getValue()));
        }
        return result;
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> binaries) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(this.getType().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeStartObject();
            for (Map.Entry entry : this.dict.entrySet()) {
                generator.writeFieldName(((TextValue)entry.getKey()).toString());
                IValue value = (IValue)entry.getValue();
                if (value == null) {
                    generator.writeNull();
                    continue;
                }
                value.toJsonStream(context, generator, System.identityHashCode(this), ((TextValue)entry.getKey()).toString(), withType, binaries);
            }
            generator.writeEndObject();
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    @Override
    public IterableWithCounts<IValue> getIterable(Context context) {
        return new KVPIterable(context);
    }

    static class KVPValue
    extends BaseValue {
        Map.Entry<TextValue, IValue> kvp;

        public KVPValue(Map.Entry<TextValue, IValue> kvp) {
            super(null);
            this.kvp = kvp;
        }

        @Override
        public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
            String name = id.toString();
            if ("key".equals(name)) {
                return this.kvp.getKey();
            }
            if ("value".equals(name)) {
                return this.kvp.getValue();
            }
            throw new SyntaxError("No such member:" + name);
        }
    }

    class KVPIterable
    implements IterableWithCounts<IValue> {
        Context context;

        public KVPIterable(Context context) {
            this.context = context;
        }

        @Override
        public Long getCount() {
            return DictionaryValue.this.dict.size();
        }

        @Override
        public Long getTotalCount() {
            return DictionaryValue.this.dict.size();
        }

        @Override
        public Iterator<IValue> iterator() {
            return new Iterator<IValue>(){
                Iterator<Map.Entry<TextValue, IValue>> iterator;
                {
                    this.iterator = DictionaryValue.this.dict.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public KVPValue next() {
                    return new KVPValue(this.iterator.next());
                }

                @Override
                public void remove() {
                    this.iterator.remove();
                }
            };
        }
    }
}

