/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDocument;
import prompto.intrinsic.PromptoSet;
import prompto.java.JavaClassType;
import prompto.runtime.Context;
import prompto.store.InvalidValueError;
import prompto.type.AnyType;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.TextType;
import prompto.value.BaseValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.ListValue;
import prompto.value.NullValue;
import prompto.value.SetValue;
import prompto.value.TextValue;

public class DocumentValue
extends BaseValue {
    PromptoDocument<Identifier, IValue> values = new PromptoDocument();

    public DocumentValue() {
        super(DocumentType.instance());
    }

    public DocumentValue(Context context, PromptoDocument<?, ?> doc, boolean docNeedsConversion) {
        super(DocumentType.instance());
        if (docNeedsConversion) {
            this.convertPromptoDocument(context, doc);
        } else {
            this.values = doc;
        }
    }

    private void convertPromptoDocument(Context context, PromptoDocument<?, ?> doc) {
        for (Object key : doc.keySet()) {
            Object value = doc.get(key);
            NullValue item = value == null ? NullValue.instance() : JavaClassType.convertJavaValueToPromptoValue(context, value, value.getClass(), AnyType.instance());
            Identifier keyId = new Identifier(String.valueOf(key));
            this.setMember(keyId, item);
        }
    }

    @Override
    public PromptoDocument<Identifier, IValue> getStorableData() {
        return this.values;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
        String name;
        switch (name = id.toString()) {
            case "count": {
                return new IntegerValue(this.values.size());
            }
            case "keys": {
                return this.getKeysValue();
            }
            case "values": {
                return new ListValue((IType)AnyType.instance(), this.values.values());
            }
        }
        return this.getMember(id, autoCreate);
    }

    private IValue getKeysValue() {
        PromptoSet keys = this.values.keySet().stream().map(Identifier::toString).map(TextValue::new).collect(Collectors.toCollection(() -> new PromptoSet()));
        return new SetValue(TextType.instance(), keys);
    }

    public Set<Identifier> getMemberIds() {
        return this.values.keySet();
    }

    private IValue getMember(Identifier id, boolean autoCreate) {
        if (this.values.containsKey(id)) {
            return (IValue)this.values.get(id);
        }
        if ("text".equals(id.toString())) {
            return new TextValue(this.toString());
        }
        if (autoCreate) {
            DocumentValue result = new DocumentValue();
            this.values.put(id, result);
            return result;
        }
        return NullValue.instance();
    }

    @Override
    public void setMember(Context context, Identifier name, IValue value) {
        this.values.put(name, value);
    }

    public void setMember(Identifier name, IValue value) {
        this.values.put(name, value);
    }

    public boolean hasMember(Identifier name) {
        return this.values.containsKey(name);
    }

    @Override
    public void setItem(Context context, IValue item, IValue value) {
        if (!(item instanceof TextValue)) {
            throw new InvalidValueError("Expected a Text, got:" + item.getClass().getName());
        }
        this.values.put(new Identifier(item.toString()), value);
    }

    @Override
    public IValue getItem(Context context, IValue item) {
        if (!(item instanceof TextValue)) {
            throw new InvalidValueError("Expected a Text, got:" + item.getClass().getName());
        }
        return this.values.getOrDefault(new Identifier(item.toString()), NullValue.instance());
    }

    @Override
    public IValue plus(Context context, IValue value) throws PromptoError {
        if (value instanceof DocumentValue) {
            PromptoDocument<Identifier, IValue> result = this.values.add(((DocumentValue)value).values);
            return new DocumentValue(context, result, false);
        }
        return super.plus(context, value);
    }

    public String toString() {
        return this.values.toString(DocumentValue::toJson, false);
    }

    static void toJson(IValue value, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> binaries) throws IOException {
        value.toJsonStream(null, generator, instanceId, fieldName, withType, binaries);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DocumentValue) {
            return this.values.equals(((DocumentValue)obj).values);
        }
        return false;
    }

    @Override
    public Object convertTo(Context context, Type type) {
        if (this.canConvertTo(type)) {
            PromptoDocument<String, Object> result = new PromptoDocument<String, Object>();
            result.putAll(this.values.entrySet().stream().collect(Collectors.toMap(e -> ((Identifier)e.getKey()).toString(), e -> ((IValue)e.getValue()).convertTo(context, (Type)((Object)Object.class)))));
            return result;
        }
        return super.convertTo(context, type);
    }

    private boolean canConvertTo(Type type) {
        return type == PromptoDocument.class || type instanceof Class && ((Class)type).isAssignableFrom(PromptoDocument.class);
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : this.values.entrySet()) {
            result.set(((Identifier)entry.getKey()).toString(), producer.apply((IValue)entry.getValue()));
        }
        return result;
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> binaries) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(DocumentType.instance().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeStartObject();
            for (Map.Entry entry : this.values.entrySet()) {
                generator.writeFieldName(((Identifier)entry.getKey()).toString());
                IValue value = (IValue)entry.getValue();
                if (value == null) {
                    generator.writeNull();
                    continue;
                }
                value.toJsonStream(context, generator, System.identityHashCode(this), ((Identifier)entry.getKey()).toString(), withType, binaries);
            }
            generator.writeEndObject();
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }
}

