/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import prompto.error.NotStorableError;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.runtime.Context;
import prompto.store.IStorable;
import prompto.type.IType;
import prompto.value.ISliceable;
import prompto.value.TextValue;

public interface IValue {
    public static int compareValues(IValue v1, IValue v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1 instanceof Comparable) {
            return ((Comparable)((Object)v1)).compareTo(v2);
        }
        return v1.toString().compareTo(v2.toString());
    }

    default public Object getStorableData() throws NotStorableError {
        throw new UnsupportedOperationException("getStorableData not supported by " + this.getClass().getSimpleName());
    }

    default public void collectStorables(Consumer<IStorable> collector) throws NotStorableError {
        throw new UnsupportedOperationException("collectStorables not supported by " + this.getClass().getSimpleName());
    }

    public void setType(IType var1);

    default public IType getType() {
        throw new UnsupportedOperationException("getType not supported by " + this.getClass().getSimpleName());
    }

    default public boolean isMutable() {
        throw new UnsupportedOperationException("isMutable not supported by " + this.getClass().getSimpleName());
    }

    default public IValue plus(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("plus not supported by " + this.getClass().getSimpleName());
    }

    default public IValue minus(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("minus not supported by " + this.getClass().getSimpleName());
    }

    default public IValue multiply(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("multiply not supported by " + this.getClass().getSimpleName());
    }

    default public IValue divide(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("divide not supported by " + this.getClass().getSimpleName());
    }

    default public IValue intDivide(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("intDivide not supported by " + this.getClass().getSimpleName());
    }

    default public IValue modulo(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("modulo not supported by " + this.getClass().getSimpleName());
    }

    default public int compareTo(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("compareTo not supported by " + this.getClass().getSimpleName());
    }

    default public void setMember(Context context, Identifier id, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("No member support for " + this.getClass().getSimpleName());
    }

    default public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
        if ("text".equals(id.toString())) {
            return new TextValue(this.toString());
        }
        throw new UnsupportedOperationException("No member support for " + this.getClass().getSimpleName());
    }

    default public void setItem(Context context, IValue item, IValue value) {
        throw new UnsupportedOperationException("No item support for " + this.getClass().getSimpleName());
    }

    default public IValue getItem(Context context, IValue item) {
        throw new UnsupportedOperationException("No item support for " + this.getClass().getSimpleName());
    }

    default public boolean roughly(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("roughly not supported by " + this.getClass().getSimpleName());
    }

    default public boolean contains(Context context, IValue value) throws PromptoError {
        throw new UnsupportedOperationException("contains not supported by " + this.getClass().getSimpleName());
    }

    default public ISliceable<IValue> asSliceable(Context context) throws PromptoError {
        throw new UnsupportedOperationException("asSliceable not supported by " + this.getClass().getSimpleName());
    }

    default public Object convertTo(Context context, Type type) throws PromptoError {
        throw new UnsupportedOperationException("convertTo " + type.getTypeName() + " not supported by " + this.getClass().getSimpleName());
    }

    default public JsonNode toTypedJsonNode(Context context) throws PromptoError {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        result.put("typeName", this.getType().getTypeName());
        result.set("value", this.valueToJsonNode(context, value -> value.toTypedJsonNode(context)));
        return result;
    }

    default public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        throw new UnsupportedOperationException("valueToJsonNode not supported by " + this.getClass().getSimpleName());
    }

    default public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> binaries) throws PromptoError {
        throw new UnsupportedOperationException("toJsonStream not supported by " + this.getClass().getSimpleName());
    }

    default public IValue toDocumentValue(Context context) {
        return this;
    }
}

