/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import prompto.intrinsic.PromptoRange;
import prompto.type.IntegerType;
import prompto.value.INumber;
import prompto.value.IntegerValue;
import prompto.value.RangeBase;

public class IntegerRange
extends RangeBase<IntegerValue> {
    public IntegerRange(IntegerValue left, IntegerValue right) {
        this(new PromptoIntegerRange(left, right));
    }

    public IntegerRange(PromptoRange<IntegerValue> range) {
        super(IntegerType.instance(), range);
    }

    @Override
    public long getLength() {
        return 1L + ((IntegerValue)this.getHigh()).longValue() - ((IntegerValue)this.getLow()).longValue();
    }

    @Override
    public RangeBase<IntegerValue> newInstance(PromptoRange<IntegerValue> range) {
        return new IntegerRange(range);
    }

    static class PromptoIntegerRange
    extends PromptoRange<IntegerValue> {
        public PromptoIntegerRange(IntegerValue low, IntegerValue high) {
            super(low, high);
        }

        @Override
        public IntegerValue getItem(long item) {
            Long result = ((IntegerValue)this.low).longValue() + item - 1L;
            if (result > ((IntegerValue)this.high).longValue()) {
                throw new IndexOutOfBoundsException();
            }
            return new IntegerValue(result);
        }

        @Override
        public long getNativeCount() {
            return 1L + ((IntegerValue)this.high).longValue() - ((IntegerValue)this.low).longValue();
        }

        public PromptoIntegerRange slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new PromptoIntegerRange(this.getItem(first), this.getItem(last));
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof IntegerValue)) {
                return false;
            }
            IntegerValue other = (IntegerValue)item;
            return other.compareTo((INumber)this.low) >= 0 && ((IntegerValue)this.high).compareTo(other) >= 0;
        }
    }
}

