/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import prompto.error.DivideByZeroError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.runtime.Context;
import prompto.type.IntegerType;
import prompto.value.BaseValue;
import prompto.value.DecimalValue;
import prompto.value.IMultiplyable;
import prompto.value.INumber;
import prompto.value.IValue;

public class IntegerValue
extends BaseValue
implements INumber,
Comparable<INumber>,
IMultiplyable {
    long value;

    public static IntegerValue Parse(String text) {
        return new IntegerValue(Long.parseLong(text));
    }

    public IntegerValue(long value) {
        super(IntegerType.instance());
        this.value = value;
    }

    @Override
    public Long getStorableData() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public IValue plus(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            return new IntegerValue(this.longValue() + ((IntegerValue)value).longValue());
        }
        if (value instanceof DecimalValue) {
            return new DecimalValue(((DecimalValue)value).doubleValue() + (double)this.value);
        }
        throw new SyntaxError("Illegal: Integer + " + value.getClass().getSimpleName());
    }

    @Override
    public IValue minus(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            return new IntegerValue(this.longValue() - ((IntegerValue)value).longValue());
        }
        if (value instanceof DecimalValue) {
            return new DecimalValue(this.doubleValue() - ((DecimalValue)value).doubleValue());
        }
        throw new SyntaxError("Illegal: Integer - " + value.getClass().getSimpleName());
    }

    @Override
    public IValue multiply(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            return new IntegerValue(this.longValue() * ((IntegerValue)value).longValue());
        }
        if (value instanceof DecimalValue) {
            return new DecimalValue(((DecimalValue)value).doubleValue() * (double)this.longValue());
        }
        if (value instanceof IMultiplyable) {
            return value.multiply(context, this);
        }
        throw new SyntaxError("Illegal: Integer * " + value.getClass().getSimpleName());
    }

    @Override
    public IValue divide(Context context, IValue value) throws PromptoError {
        if (value instanceof INumber) {
            if (((INumber)value).doubleValue() == 0.0) {
                throw new DivideByZeroError();
            }
            return new DecimalValue(this.doubleValue() / ((INumber)value).doubleValue());
        }
        throw new SyntaxError("Illegal: Integer / " + value.getClass().getSimpleName());
    }

    @Override
    public IValue intDivide(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            if (((IntegerValue)value).longValue() == 0L) {
                throw new DivideByZeroError();
            }
            return new IntegerValue(this.longValue() / ((IntegerValue)value).longValue());
        }
        throw new SyntaxError("Illegal: Integer \\ " + value.getClass().getSimpleName());
    }

    @Override
    public IValue modulo(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            long mod = ((IntegerValue)value).longValue();
            if (mod == 0L) {
                throw new DivideByZeroError();
            }
            return new IntegerValue(this.longValue() % mod);
        }
        throw new SyntaxError("Illegal: Integer % " + value.getClass().getSimpleName());
    }

    @Override
    public int compareTo(INumber obj) {
        return Long.compare(this.value, obj.longValue());
    }

    @Override
    public int compareTo(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            return Long.compare(this.value, ((IntegerValue)value).longValue());
        }
        if (value instanceof DecimalValue) {
            return Double.compare(this.doubleValue(), ((DecimalValue)value).doubleValue());
        }
        throw new SyntaxError("Illegal comparison: Integer and " + value.getClass().getSimpleName());
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerValue) {
            return this.value == ((IntegerValue)obj).value;
        }
        if (obj instanceof DecimalValue) {
            return (double)this.value == ((DecimalValue)obj).value;
        }
        return false;
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.numberNode(this.value);
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            generator.writeNumber(this.value);
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    public IValue negate() {
        return new IntegerValue(-this.value);
    }
}

