/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import prompto.error.IndexOutOfRangeError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.Filterable;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoList;
import prompto.java.JavaClassType;
import prompto.runtime.Context;
import prompto.store.IStorable;
import prompto.store.InvalidValueError;
import prompto.type.AnyType;
import prompto.type.ContainerType;
import prompto.type.IType;
import prompto.type.ListType;
import prompto.value.BaseValue;
import prompto.value.IContainer;
import prompto.value.IFilterable;
import prompto.value.ISliceable;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.IteratorValue;
import prompto.value.SetValue;

public class ListValue
extends BaseValue
implements IContainer<IValue>,
ISliceable<IValue>,
IFilterable {
    PromptoList<IValue> items;
    List<Object> storables;

    public ListValue(IType itemType) {
        super(new ListType(itemType));
        this.items = new PromptoList(false);
    }

    public ListValue(IType itemType, PromptoList<IValue> items) {
        super(new ListType(itemType));
        this.items = items;
    }

    public ListValue(IType itemType, Collection<? extends IValue> items) {
        super(new ListType(itemType));
        this.items = new PromptoList<IValue>(items, false);
    }

    public ListValue(IType itemType, Collection<? extends IValue> items, boolean mutable) {
        super(new ListType(itemType));
        this.items = new PromptoList<IValue>(items, mutable);
    }

    public ListValue(Context context, PromptoList<?> list) {
        super(new ListType(AnyType.instance()));
        List items = list.stream().map(item -> JavaClassType.convertJavaValueToPromptoValue(context, item, item.getClass(), AnyType.instance())).collect(Collectors.toList());
        this.items = new PromptoList(items, false);
    }

    @Override
    public boolean isMutable() {
        return this.items.isMutable();
    }

    @Override
    public Object getStorableData() {
        if (this.storables == null) {
            this.storables = new ArrayList<Object>();
            for (IValue item : this.items) {
                this.storables.add(item.getStorableData());
            }
        }
        return this.storables;
    }

    @Override
    public void collectStorables(Consumer<IStorable> collector) {
        this.items.forEach(value -> value.collectStorables(collector));
    }

    public String toString() {
        return this.items.toString();
    }

    public IType getItemType() {
        return ((ContainerType)this.type).getItemType();
    }

    public PromptoList<IValue> getItems() {
        return this.items;
    }

    public void addItem(IValue item) {
        this.items.add(item);
    }

    public IValue getItem(int index) {
        return (IValue)this.items.get(index);
    }

    public void setItem(int index, IValue element) {
        this.items.set(index, element);
    }

    @Override
    public void setItem(Context context, IValue item, IValue value) {
        if (!(item instanceof IntegerValue)) {
            throw new InvalidValueError("Expected an Integer, got:" + item.getClass().getName());
        }
        int index = (int)((IntegerValue)item).longValue();
        if (index < 1 || (long)index > this.getLength()) {
            throw new IndexOutOfRangeError();
        }
        this.setItem(index - 1, value);
    }

    @Override
    public IValue getItem(Context context, IValue index) throws PromptoError {
        if (index instanceof IntegerValue) {
            try {
                int idx = (int)((IntegerValue)index).longValue() - 1;
                return (IValue)this.items.get(idx);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfRangeError();
            }
        }
        throw new SyntaxError("No such item:" + index.toString());
    }

    @Override
    public boolean hasItem(Context context, IValue lval) throws PromptoError {
        return this.items.contains(lval);
    }

    @Override
    public long getLength() {
        return this.items.size();
    }

    @Override
    public Filterable<IValue, IValue> getFilterable(Context context) {
        return new Filterable<IValue, IValue>(){

            @Override
            public IValue filter(Predicate<IValue> p) {
                Object filtered = ListValue.this.items.filter((Predicate)p);
                return new ListValue(ListValue.this.getItemType(), (PromptoList<IValue>)filtered);
            }
        };
    }

    @Override
    public IterableWithCounts<IValue> getIterable(Context context) {
        return new IterableWithCounts<IValue>(){

            @Override
            public Long getCount() {
                return ListValue.this.items.size();
            }

            @Override
            public Long getTotalCount() {
                return ListValue.this.items.size();
            }

            @Override
            public Iterator<IValue> iterator() {
                return ListValue.this.items.iterator();
            }
        };
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) {
        String name = id.toString();
        if ("count".equals(name)) {
            return new IntegerValue(this.items.size());
        }
        if ("iterator".equals(name)) {
            return new IteratorValue(this.getItemType(), this.getIterable(context).iterator());
        }
        return super.getMember(context, id, autoCreate);
    }

    @Override
    public IValue plus(Context context, IValue value) {
        if (value instanceof ListValue) {
            return this.merge(((ListValue)value).getItems());
        }
        if (value instanceof SetValue) {
            return this.merge(((SetValue)value).getItems());
        }
        throw new SyntaxError("Illegal: " + this.type.getTypeName() + " + " + value.getClass().getSimpleName());
    }

    protected ListValue merge(Collection<? extends IValue> items) {
        PromptoList<IValue> result = new PromptoList<IValue>(false);
        result.addAll(this.items);
        result.addAll(items);
        IType itemType = ((ContainerType)this.getType()).getItemType();
        return new ListValue(itemType, result);
    }

    @Override
    public IValue minus(Context context, IValue value) throws PromptoError {
        if (value instanceof ListValue) {
            return this.remove(((ListValue)value).getItems());
        }
        if (value instanceof SetValue) {
            return this.remove(((SetValue)value).getItems());
        }
        throw new SyntaxError("Illegal: " + this.type.getTypeName() + " + " + value.getClass().getSimpleName());
    }

    protected ListValue remove(Collection<? extends IValue> items) {
        PromptoList<IValue> result = new PromptoList<IValue>(false);
        result.addAll(this.items);
        result.removeAll(items);
        IType itemType = ((ContainerType)this.getType()).getItemType();
        return new ListValue(itemType, result);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListValue)) {
            return false;
        }
        return this.items.equals(((ListValue)obj).items);
    }

    @Override
    public IValue multiply(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            IType itemType = ((ContainerType)this.type).getItemType();
            int count = (int)((IntegerValue)value).longValue();
            if (count < 0) {
                throw new SyntaxError("Negative repeat count:" + count);
            }
            return new ListValue(itemType, this.items.multiply(count));
        }
        throw new SyntaxError("Illegal: List * " + value.getClass().getSimpleName());
    }

    public ListValue slice(IntegerValue fi, IntegerValue li) throws IndexOutOfRangeError {
        long _li;
        long _fi;
        long l = _fi = fi == null ? 1L : fi.longValue();
        if (_fi < 0L) {
            throw new IndexOutOfRangeError();
        }
        long l2 = _li = li == null ? (long)this.items.size() : li.longValue();
        if (_li > (long)this.items.size()) {
            throw new IndexOutOfRangeError();
        }
        PromptoList<IValue> sliced = this.items.slice(_fi, _li);
        return new ListValue(this.getItemType(), sliced);
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        for (IValue item : this.items) {
            result.add(producer.apply(item));
        }
        return result;
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(this.getType().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeStartArray();
            for (IValue value : this.items) {
                value.toJsonStream(context, generator, System.identityHashCode(this), null, withType, data);
            }
            generator.writeEndArray();
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    @Override
    public Object convertTo(Context context, Type type) {
        if (this.canConvertTo(type)) {
            Type itemType = this.getItemType(type);
            PromptoList result = new PromptoList(true);
            this.items.forEach(item -> result.add(item.convertTo(context, itemType)));
            return result;
        }
        return super.convertTo(context, type);
    }

    private boolean canConvertTo(Type type) {
        return type == PromptoList.class || type instanceof Class && ((Class)type).isAssignableFrom(PromptoList.class);
    }

    private Type getItemType(Type type) {
        return type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
    }
}

