/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.SetterMethodDeclaration;
import prompto.error.InternalError;
import prompto.error.NotMutableError;
import prompto.error.NotStorableError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.java.JavaClassType;
import prompto.runtime.Context;
import prompto.runtime.Variable;
import prompto.store.DataStore;
import prompto.store.IStorable;
import prompto.type.CategoryType;
import prompto.type.NativeCategoryType;
import prompto.value.BaseValue;
import prompto.value.IInstance;
import prompto.value.IValue;

public class NativeInstance
extends BaseValue
implements IInstance {
    NativeCategoryDeclaration declaration;
    Object instance = null;
    IStorable storable = null;
    boolean mutable = false;
    ThreadLocal<Map<Identifier, Context>> activeGetters = new ThreadLocal<Map<Identifier, Context>>(){

        @Override
        protected Map<Identifier, Context> initialValue() {
            return new HashMap<Identifier, Context>();
        }
    };
    ThreadLocal<Map<Identifier, Context>> activeSetters = new ThreadLocal<Map<Identifier, Context>>(){

        @Override
        protected Map<Identifier, Context> initialValue() {
            return new HashMap<Identifier, Context>();
        }
    };

    public NativeInstance(Context context, NativeCategoryDeclaration declaration) {
        super(new NativeCategoryType(declaration));
        this.declaration = declaration;
        this.instance = this.makeInstance(context);
        if (declaration.isStorable(context)) {
            List<String> categories = Arrays.asList(declaration.getName());
            this.storable = DataStore.getInstance().newStorable(categories, null);
        }
    }

    public NativeInstance(NativeCategoryDeclaration declaration, Object instance) {
        super(new NativeCategoryType(declaration));
        this.declaration = declaration;
        this.instance = instance;
        if (declaration.isStorable(null)) {
            List<String> categories = Arrays.asList(declaration.getName());
            this.storable = DataStore.getInstance().newStorable(categories, null);
        }
    }

    @Override
    public Object getStorableData() {
        if (this.storable == null) {
            throw new NotStorableError();
        }
        return this.getOrCreateDbId();
    }

    private Object getOrCreateDbId() throws NotStorableError {
        Object dbId = this.getDbId();
        if (dbId == null) {
            dbId = this.storable.getOrCreateDbId();
            this.setDbId(dbId);
        }
        return dbId;
    }

    @Override
    public IStorable getStorable() {
        return this.storable;
    }

    @Override
    public NativeCategoryDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public boolean setMutable(boolean mutable) {
        boolean result = this.mutable;
        this.mutable = mutable;
        return result;
    }

    @Override
    public void collectStorables(Consumer<IStorable> collector) throws PromptoError {
        if (this.storable == null) {
            throw new NotStorableError();
        }
        if (this.storable.isDirty()) {
            this.getOrCreateDbId();
            collector.accept(this.storable);
        }
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public Object getInstance() {
        return this.instance;
    }

    private Object makeInstance(Context context) {
        try {
            Class<?> mapped = this.declaration.getBoundClass(true);
            return mapped.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CategoryType getType() {
        return (CategoryType)this.type;
    }

    @Override
    public Set<Identifier> getMemberIds() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue getMember(Context context, Identifier attrName, boolean autoCreate) throws PromptoError {
        boolean first;
        if ("category".equals(attrName.toString())) {
            return this.getCategory(context);
        }
        Map<Identifier, Context> activeGetters = this.activeGetters.get();
        Context stacked = activeGetters.get(attrName);
        boolean bl = first = stacked == null;
        if (first) {
            activeGetters.put(attrName, context);
        }
        try {
            IValue iValue = this.getMemberAllowGetter(context, attrName, first);
            return iValue;
        }
        finally {
            if (first) {
                activeGetters.remove(attrName);
            }
        }
    }

    private IValue getCategory(Context context) {
        NativeCategoryDeclaration decl = context.getRegisteredDeclaration(NativeCategoryDeclaration.class, new Identifier("Category"));
        return new NativeInstance(decl, (Object)this.declaration);
    }

    public IValue getMemberAllowGetter(Context context, Identifier attrName, boolean allowGetter) throws PromptoError {
        GetterMethodDeclaration promptoGetter;
        GetterMethodDeclaration getterMethodDeclaration = promptoGetter = allowGetter ? this.declaration.findGetter(context, attrName) : null;
        if (promptoGetter != null) {
            context = context.newInstanceContext(this, false).newChildContext();
            return promptoGetter.interpret(context);
        }
        Method nativeGetter = this.getGetter(attrName);
        Object value = this.getValue(nativeGetter);
        JavaClassType ct = new JavaClassType(value.getClass());
        return ct.convertJavaValueToPromptoValue(context, value, null);
    }

    private Object getValue(Method getter) throws PromptoError {
        try {
            getter.setAccessible(true);
            return getter.invoke(this.instance, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new InternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMember(Context context, Identifier attrName, IValue value) throws PromptoError {
        if (!this.mutable) {
            throw new NotMutableError();
        }
        Map<Identifier, Context> activeSetters = this.activeSetters.get();
        Context stacked = activeSetters.get(attrName);
        boolean first = stacked == null;
        try {
            if (first) {
                activeSetters.put(attrName, context);
            }
            this.setMember(context, attrName, value, first);
        }
        finally {
            if (first) {
                activeSetters.remove(attrName);
            }
        }
    }

    public void setMember(Context context, Identifier attrName, IValue value, boolean allowSetter) throws PromptoError {
        SetterMethodDeclaration promptoSetter;
        AttributeDeclaration decl = context.getRegisteredDeclaration(AttributeDeclaration.class, attrName);
        SetterMethodDeclaration setterMethodDeclaration = promptoSetter = allowSetter ? this.declaration.findSetter(context, attrName) : null;
        if (promptoSetter != null) {
            context = context.newInstanceContext(this, false).newChildContext();
            context.registerValue(new Variable(attrName, decl.getType()));
            context.setValue(attrName, value);
            value = promptoSetter.interpret(context);
        } else {
            Method nativeSetter = this.getSetter(attrName);
            Object data = value.convertTo(context, nativeSetter.getParameterTypes()[0]);
            this.setValue(nativeSetter, data);
            if (this.storable != null && decl.isStorable(context)) {
                this.storable.setData(attrName.toString(), data);
            }
        }
    }

    public Object getDbId() {
        try {
            Field field = this.instance.getClass().getDeclaredField("dbId");
            field.setAccessible(true);
            return field.get(this.instance);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void setDbId(Object dbId) {
        try {
            Field field = this.instance.getClass().getDeclaredField("dbId");
            field.setAccessible(true);
            field.set(this.instance, dbId);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void setValue(Method setter, Object data) throws PromptoError {
        try {
            setter.setAccessible(true);
            setter.invoke(this.instance, data);
        }
        catch (IllegalArgumentException e) {
            throw new SyntaxError("Cannot assign " + data.getClass().getSimpleName() + " to " + setter.getParameterTypes()[0].getSimpleName());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InternalError(e);
        }
    }

    private Method getSetter(Identifier attrName) {
        String setterName = "set" + attrName.toString().substring(0, 1).toUpperCase() + attrName.toString().substring(1);
        Method m = this.getMethod(attrName, setterName);
        if (m == null) {
            throw new SyntaxError("Missing setter for:" + attrName);
        }
        return m;
    }

    private Method getGetter(Identifier attrName) {
        String setterName = "get" + attrName.toString().substring(0, 1).toUpperCase() + attrName.toString().substring(1);
        Method m = this.getMethod(attrName, setterName);
        if (m == null) {
            throw new SyntaxError("Missing getter for:" + attrName);
        }
        return m;
    }

    private Method getMethod(Identifier attrName, String name) {
        for (Method method : this.instance.getClass().getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            generator.writeStartObject();
            for (Identifier attrName : this.declaration.getAllAttributes(context)) {
                generator.writeFieldName(attrName.toString());
                IValue value = this.getMember(context, attrName, false);
                if (value == null) {
                    generator.writeNull();
                    continue;
                }
                Integer id = System.identityHashCode(this);
                value.toJsonStream(context, generator, id, attrName.toString(), withType, data);
            }
            generator.writeEndObject();
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    @Override
    public IValue toMutable() {
        throw new UnsupportedOperationException();
    }
}

