/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import java.lang.reflect.Type;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.intrinsic.PromptoPeriod;
import prompto.runtime.Context;
import prompto.type.PeriodType;
import prompto.value.BaseValue;
import prompto.value.IMultiplyable;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class PeriodValue
extends BaseValue
implements IMultiplyable {
    public static final PeriodValue ZERO = new PeriodValue(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    PromptoPeriod value;

    public PeriodValue(long years, long months, long weeks, long days, long hours, long minutes, long seconds, long millis) {
        super(PeriodType.instance());
        this.value = new PromptoPeriod(years, months, weeks, days, hours, minutes, seconds, millis);
    }

    public PeriodValue(PromptoPeriod value) {
        super(PeriodType.instance());
        this.value = value;
    }

    @Override
    public PromptoPeriod getStorableData() {
        return this.value;
    }

    @Override
    public IValue plus(Context context, IValue value) throws PromptoError {
        if (value instanceof PeriodValue) {
            return new PeriodValue(this.value.plus(((PeriodValue)value).value));
        }
        throw new SyntaxError("Illegal: Period + " + value.getClass().getSimpleName());
    }

    @Override
    public IValue minus(Context context, IValue value) throws PromptoError {
        if (value instanceof PeriodValue) {
            return new PeriodValue(this.value.minus(((PeriodValue)value).value));
        }
        throw new SyntaxError("Illegal: Period - " + value.getClass().getSimpleName());
    }

    @Override
    public IValue multiply(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            int count = (int)((IntegerValue)value).longValue();
            if (count < 0) {
                throw new SyntaxError("Negative repeat count:" + count);
            }
            if (count == 0) {
                return ZERO;
            }
            if (count == 1) {
                return this;
            }
            return new PeriodValue(this.value.multiply(count));
        }
        throw new SyntaxError("Illegal: Period * " + value.getClass().getSimpleName());
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeriodValue) {
            return this.value.equals(((PeriodValue)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public IValue negate() {
        return new PeriodValue(this.value.negate());
    }
}

