/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.function.Function;
import prompto.error.IndexOutOfRangeError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoRange;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.RangeType;
import prompto.value.BaseValue;
import prompto.value.IContainer;
import prompto.value.IRange;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public abstract class RangeBase<T extends IValue>
extends BaseValue
implements IContainer<T>,
IRange<T> {
    PromptoRange<T> range;

    protected RangeBase(IType type, PromptoRange<T> range) {
        super(new RangeType(type));
        this.range = range;
    }

    @Override
    public Object getStorableData() {
        return this.range;
    }

    public String toString() {
        return this.range.toString();
    }

    public T getLow() {
        return (T)((IValue)this.range.getLow());
    }

    public T getHigh() {
        return (T)((IValue)this.range.getHigh());
    }

    @Override
    public long getLength() {
        return this.range.getNativeCount();
    }

    public boolean equals(Object obj) {
        return obj instanceof RangeBase && this.range.equals(((RangeBase)obj).range);
    }

    @Override
    public boolean hasItem(Context context, IValue lval) {
        return this.range.contains(lval);
    }

    @Override
    public T getItem(Context context, IValue index) throws PromptoError {
        if (index instanceof IntegerValue) {
            try {
                return (T)((IValue)this.range.getItem(((IntegerValue)index).longValue()));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfRangeError();
            }
        }
        throw new SyntaxError("No such item:" + index.toString());
    }

    @Override
    public RangeBase<T> slice(IntegerValue fi, IntegerValue li) throws PromptoError {
        try {
            long _fi = fi == null ? 1L : fi.longValue();
            long _li = li == null ? -1L : li.longValue();
            PromptoRange<T> sliced = this.range.slice(_fi, _li);
            return this.newInstance(sliced);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfRangeError();
        }
    }

    @Override
    public IterableWithCounts<T> getIterable(Context context) {
        return new RangeIterable(context);
    }

    public abstract RangeBase<T> newInstance(PromptoRange<T> var1);

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        result.set("low", producer.apply((IValue)this.getLow()));
        result.set("high", producer.apply((IValue)this.getHigh()));
        ObjectNode value = JsonNodeFactory.instance.objectNode();
        value.put("typeName", IntegerType.instance().getTypeName());
        value.put("value", this.getLength());
        result.set("count", (JsonNode)value);
        return result;
    }

    class RangeIterable
    implements IterableWithCounts<T> {
        Context context;

        public RangeIterable(Context context) {
            this.context = context;
        }

        @Override
        public Long getCount() {
            return RangeBase.this.getLength();
        }

        @Override
        public Long getTotalCount() {
            return RangeBase.this.getLength();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                long index = 0L;
                long length;
                {
                    this.length = RangeBase.this.getLength();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.length;
                }

                @Override
                public T next() {
                    try {
                        return RangeBase.this.getItem(RangeIterable.this.context, new IntegerValue(++this.index));
                    }
                    catch (Throwable t) {
                        throw new InternalError(t.getMessage());
                    }
                }

                @Override
                public void remove() {
                    throw new RuntimeException("Shold never get there!");
                }
            };
        }
    }
}

