/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.Collator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import prompto.error.IndexOutOfRangeError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoString;
import prompto.runtime.Context;
import prompto.type.TextType;
import prompto.value.BaseValue;
import prompto.value.CharacterValue;
import prompto.value.IContainer;
import prompto.value.IMultiplyable;
import prompto.value.ISliceable;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class TextValue
extends BaseValue
implements Comparable<TextValue>,
IContainer<CharacterValue>,
ISliceable<CharacterValue>,
IMultiplyable {
    String value;

    public TextValue(String value) {
        super(TextType.instance());
        this.value = value;
    }

    @Override
    public String getStorableData() {
        return this.value;
    }

    @Override
    public long getLength() {
        return this.value.length();
    }

    @Override
    public IValue plus(Context context, IValue value) {
        return new TextValue(this.value + value.toString());
    }

    @Override
    public IValue multiply(Context context, IValue value) throws PromptoError {
        if (value instanceof IntegerValue) {
            int count = (int)((IntegerValue)value).longValue();
            if (count < 0) {
                throw new SyntaxError("Negative repeat count:" + count);
            }
            return new TextValue(PromptoString.multiply(this.value, count));
        }
        throw new SyntaxError("Illegal: Chararacter * " + value.getClass().getSimpleName());
    }

    @Override
    public int compareTo(TextValue obj) {
        return this.value.compareTo(obj.value);
    }

    @Override
    public int compareTo(Context context, IValue value) throws PromptoError {
        if (value instanceof TextValue) {
            return this.value.compareTo(((TextValue)value).value);
        }
        throw new SyntaxError("Illegal comparison: Text + " + value.getClass().getSimpleName());
    }

    @Override
    public boolean hasItem(Context context, IValue value) throws PromptoError {
        if (value instanceof CharacterValue) {
            return this.value.indexOf(((CharacterValue)value).value) >= 0;
        }
        if (value instanceof TextValue) {
            return this.value.indexOf(((TextValue)value).value) >= 0;
        }
        throw new SyntaxError("Illegal contain: Text + " + value.getClass().getSimpleName());
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) {
        String name = id.toString();
        if ("count".equals(name)) {
            return new IntegerValue(this.value.length());
        }
        return super.getMember(context, id, autoCreate);
    }

    @Override
    public CharacterValue getItem(Context context, IValue index) throws PromptoError {
        try {
            if (index instanceof IntegerValue) {
                return new CharacterValue(this.value.charAt((int)((IntegerValue)index).longValue() - 1));
            }
            throw new SyntaxError("No such item:" + index.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfRangeError();
        }
    }

    @Override
    public IterableWithCounts<CharacterValue> getIterable(Context context) {
        return new CharacterIterable(context);
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return this.value;
    }

    @Override
    public ISliceable<CharacterValue> slice(IntegerValue fi, IntegerValue li) throws PromptoError {
        int first = this.checkSliceFirst(fi);
        int last = this.checkSliceLast(li);
        return new TextValue(this.value.substring(first - 1, last));
    }

    private int checkSliceFirst(IntegerValue fi) throws IndexOutOfRangeError {
        int value;
        int n = value = fi == null ? 1 : (int)fi.longValue();
        if (value < 1 || value > this.value.length()) {
            throw new IndexOutOfRangeError();
        }
        return value;
    }

    private int checkSliceLast(IntegerValue li) throws IndexOutOfRangeError {
        int value;
        int n = value = li == null ? this.value.length() : (int)li.longValue();
        if (value < 0) {
            value = this.value.length() + 1 + (int)li.longValue();
        }
        if (value < 1 || value > this.value.length()) {
            throw new IndexOutOfRangeError();
        }
        return value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextValue) {
            return this.value.equals(((TextValue)obj).value);
        }
        return this.value.equals(obj);
    }

    @Override
    public boolean roughly(Context context, IValue obj) throws PromptoError {
        if (obj instanceof CharacterValue || obj instanceof TextValue) {
            Collator c = Collator.getInstance();
            c.setStrength(0);
            return c.compare(this.value, obj.toString()) == 0;
        }
        return false;
    }

    @Override
    public boolean contains(Context context, IValue obj) throws PromptoError {
        if (obj instanceof TextValue) {
            return this.value.contains(((TextValue)obj).value);
        }
        if (obj instanceof CharacterValue) {
            return this.value.indexOf(((CharacterValue)obj).value) >= 0;
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.textNode(this.value);
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            generator.writeString(this.value);
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    @Override
    public IValue toDocumentValue(Context context) {
        return this;
    }

    class CharacterIterable
    implements IterableWithCounts<CharacterValue> {
        Context context;

        public CharacterIterable(Context context) {
            this.context = context;
        }

        @Override
        public Long getCount() {
            return TextValue.this.value.length();
        }

        @Override
        public Long getTotalCount() {
            return TextValue.this.value.length();
        }

        @Override
        public Iterator<CharacterValue> iterator() {
            return new Iterator<CharacterValue>(){
                int index = -1;

                @Override
                public boolean hasNext() {
                    return this.index < TextValue.this.value.length() - 1;
                }

                @Override
                public CharacterValue next() {
                    return new CharacterValue(TextValue.this.value.charAt(++this.index));
                }

                @Override
                public void remove() {
                    throw new InternalError("Should never get there!");
                }
            };
        }
    }
}

