/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import prompto.intrinsic.PromptoRange;
import prompto.intrinsic.PromptoTime;
import prompto.type.TimeType;
import prompto.value.RangeBase;
import prompto.value.TimeValue;

public class TimeRange
extends RangeBase<TimeValue> {
    public TimeRange(TimeValue left, TimeValue right) {
        this(new PromptoTimeRange(left, right));
    }

    public TimeRange(PromptoRange<TimeValue> range) {
        super(TimeType.instance(), range);
    }

    @Override
    public RangeBase<TimeValue> newInstance(PromptoRange<TimeValue> range) {
        return new TimeRange(range);
    }

    static class PromptoTimeRange
    extends PromptoRange<TimeValue> {
        public PromptoTimeRange(TimeValue low, TimeValue high) {
            super(low, high);
        }

        @Override
        public TimeValue getItem(long item) {
            PromptoTime result = ((TimeValue)this.low).value.plusSeconds(item - 1L);
            if (result.isAfter(((TimeValue)this.high).value)) {
                throw new IndexOutOfBoundsException();
            }
            return new TimeValue(result);
        }

        public PromptoTimeRange slice(long first, long last) {
            last = this.adjustLastSliceIndex(last);
            return new PromptoTimeRange(this.getItem(first), this.getItem(last));
        }

        @Override
        public long getNativeCount() {
            return 1L + (((TimeValue)this.high).getMillisOfDay() - ((TimeValue)this.low).getMillisOfDay()) / 1000L;
        }

        @Override
        public boolean contains(Object item) {
            if (!(item instanceof TimeValue)) {
                return false;
            }
            TimeValue other = (TimeValue)item;
            return other.compareTo((TimeValue)this.low) >= 0 && ((TimeValue)this.high).compareTo(other) >= 0;
        }
    }
}

