/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import prompto.error.IndexOutOfRangeError;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.grammar.Identifier;
import prompto.intrinsic.IterableWithCounts;
import prompto.intrinsic.PromptoTuple;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.store.InvalidValueError;
import prompto.type.TupleType;
import prompto.utils.CodeWriter;
import prompto.value.BaseValue;
import prompto.value.IContainer;
import prompto.value.ISliceable;
import prompto.value.IValue;
import prompto.value.IntegerValue;
import prompto.value.ListValue;
import prompto.value.SetValue;

public class TupleValue
extends BaseValue
implements IContainer<IValue>,
ISliceable<IValue> {
    protected PromptoTuple<IValue> items;

    public TupleValue(boolean mutable) {
        super(TupleType.instance());
        this.items = new PromptoTuple(mutable);
    }

    public TupleValue(PromptoTuple<IValue> items) {
        super(TupleType.instance());
        this.items = items;
    }

    public TupleValue(Collection<IValue> items, boolean mutable) {
        super(TupleType.instance());
        this.items = new PromptoTuple<IValue>(items, mutable);
    }

    @Override
    public boolean isMutable() {
        return this.items.isMutable();
    }

    @Override
    public PromptoTuple<IValue> getStorableData() {
        return this.items;
    }

    public String toString() {
        String result = this.items.toString();
        return "(" + result.substring(1, result.length() - 1) + ")";
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        ArrayNode result = JsonNodeFactory.instance.arrayNode();
        for (IValue item : this.items) {
            result.add(producer.apply(item));
        }
        return result;
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(this.getType().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeStartArray();
            for (IValue value : this.items) {
                value.toJsonStream(context, generator, System.identityHashCode(this), null, withType, data);
            }
            generator.writeEndArray();
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }

    public void addItem(IValue item) {
        this.items.add(item);
    }

    public PromptoTuple<IValue> getItems() {
        return this.items;
    }

    public IValue getItem(int index) {
        return (IValue)this.items.get(index);
    }

    public void setItem(int index, IValue element) {
        this.items.set(index, element);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TupleValue)) {
            return false;
        }
        return this.items.equals(((TupleValue)obj).items);
    }

    public void toDialect(CodeWriter writer) {
        writer.append('(');
        if (this.items.size() > 0) {
            for (Object e : this.items) {
                if (e instanceof Literal) {
                    ((Literal)e).toDialect(writer);
                } else {
                    writer.append(e.toString());
                }
                writer.append(", ");
            }
            writer.trimLast(2);
        }
        writer.append(')');
    }

    public TupleValue slice(IntegerValue fi, IntegerValue li) throws IndexOutOfRangeError {
        long _li;
        long _fi;
        long l = _fi = fi == null ? 1L : fi.longValue();
        if (_fi < 0L) {
            throw new IndexOutOfRangeError();
        }
        long l2 = _li = li == null ? (long)this.items.size() : li.longValue();
        if (_li > (long)this.items.size()) {
            throw new IndexOutOfRangeError();
        }
        PromptoTuple<IValue> sliced = this.items.slice(_fi, _li);
        return new TupleValue(sliced, false);
    }

    @Override
    public long getLength() {
        return this.items.size();
    }

    @Override
    public boolean hasItem(Context context, IValue lval) throws PromptoError {
        return this.items.contains(lval);
    }

    @Override
    public void setItem(Context context, IValue item, IValue value) {
        if (!(item instanceof IntegerValue)) {
            throw new InvalidValueError("Expected an Integer, got:" + item.getClass().getName());
        }
        int index = (int)((IntegerValue)item).longValue();
        if (index < 1 || (long)index > this.getLength()) {
            throw new IndexOutOfRangeError();
        }
        this.setItem(index - 1, value);
    }

    @Override
    public IValue getItem(Context context, IValue index) throws PromptoError {
        if (index instanceof IntegerValue) {
            try {
                int idx = (int)((IntegerValue)index).longValue() - 1;
                return (IValue)this.items.get(idx);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfRangeError();
            }
        }
        throw new SyntaxError("No such item:" + index.toString());
    }

    @Override
    public IValue plus(Context context, IValue value) throws PromptoError {
        if (value instanceof ListValue) {
            return this.merge(((ListValue)value).getItems());
        }
        if (value instanceof TupleValue) {
            return this.merge(((TupleValue)value).getItems());
        }
        if (value instanceof SetValue) {
            return this.merge(((SetValue)value).getItems());
        }
        throw new SyntaxError("Illegal: " + this.type.getTypeName() + " + " + value.getClass().getSimpleName());
    }

    protected TupleValue merge(Collection<? extends IValue> items) {
        PromptoTuple<IValue> result = new PromptoTuple<IValue>(false);
        result.addAll(this.items);
        result.addAll(items);
        return new TupleValue(result);
    }

    @Override
    public IterableWithCounts<IValue> getIterable(Context context) {
        return new IterableWithCounts<IValue>(){

            @Override
            public Long getCount() {
                return TupleValue.this.items.size();
            }

            @Override
            public Long getTotalCount() {
                return TupleValue.this.items.size();
            }

            @Override
            public Iterator<IValue> iterator() {
                return TupleValue.this.items.iterator();
            }
        };
    }

    @Override
    public IValue getMember(Context context, Identifier id, boolean autoCreate) throws PromptoError {
        String name = id.toString();
        if ("count".equals(name)) {
            return new IntegerValue(this.items.size());
        }
        return super.getMember(context, id, autoCreate);
    }

    @Override
    public int compareTo(Context context, IValue value) throws PromptoError {
        if (!(value instanceof TupleValue)) {
            return super.compareTo(context, value);
        }
        return this.compareTo(context, (TupleValue)value, new ArrayList<Boolean>());
    }

    public int compareTo(Context context, TupleValue other, Collection<Boolean> directions) throws PromptoError {
        boolean descending;
        Iterator<Boolean> iterDirs = directions.iterator();
        Iterator iterThis = this.items.iterator();
        Iterator iterOther = other.items.iterator();
        while (iterThis.hasNext() && iterOther.hasNext()) {
            descending = iterDirs.hasNext() ? iterDirs.next() : false;
            IValue thisVal = (IValue)iterThis.next();
            IValue otherVal = (IValue)iterOther.next();
            if (thisVal == null && otherVal == null) continue;
            if (thisVal == null) {
                return descending ? 1 : -1;
            }
            if (otherVal == null) {
                return descending ? -1 : 1;
            }
            int cmp = thisVal.compareTo(context, otherVal);
            if (cmp == 0) continue;
            return descending ? -cmp : cmp;
        }
        boolean bl = descending = iterDirs.hasNext() ? iterDirs.next() : false;
        if (iterThis.hasNext()) {
            return descending ? -1 : 1;
        }
        if (iterOther.hasNext()) {
            return descending ? 1 : -1;
        }
        return 0;
    }
}

