/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.runtime.Context;
import prompto.type.UuidType;
import prompto.value.BaseValue;
import prompto.value.IValue;

public class UuidValue
extends BaseValue {
    UUID value;

    public UuidValue(String value) {
        super(UuidType.instance());
        this.value = UUID.fromString(value);
    }

    public UuidValue(UUID value) {
        super(UuidType.instance());
        this.value = value;
    }

    public UUID getValue() {
        return this.value;
    }

    @Override
    public UUID getStorableData() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UuidValue) {
            return this.value.equals(((UuidValue)obj).value);
        }
        return this.value.equals(obj);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.textNode(this.value.toString());
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeFieldName("type");
                generator.writeString(UuidType.instance().getTypeName());
                generator.writeFieldName("value");
                generator.writeString(this.toString());
                generator.writeEndObject();
            } else {
                generator.writeString(this.toString());
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }
}

