/*
 * Decompiled with CFR 0.152.
 */
package prompto.value;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import prompto.error.PromptoError;
import prompto.error.ReadWriteError;
import prompto.error.SyntaxError;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.Context;
import prompto.type.DateType;
import prompto.type.VersionType;
import prompto.value.BaseValue;
import prompto.value.IValue;

public class VersionValue
extends BaseValue
implements Comparable<VersionValue> {
    PromptoVersion value;

    public static VersionValue Parse(String text) {
        PromptoVersion value = PromptoVersion.parse(text);
        return new VersionValue(value);
    }

    public VersionValue(PromptoVersion value) {
        super(DateType.instance());
        this.value = value;
    }

    @Override
    public PromptoVersion getStorableData() {
        return this.value;
    }

    @Override
    public int compareTo(Context context, IValue value) throws PromptoError {
        if (value instanceof VersionValue) {
            return this.value.compareTo(((VersionValue)value).value);
        }
        throw new SyntaxError("Illegal comparison: Version - " + value.getClass().getSimpleName());
    }

    @Override
    public Object convertTo(Context context, Type type) {
        return this.value;
    }

    @Override
    public int compareTo(VersionValue other) {
        return this.value.compareTo(other.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VersionValue) {
            return this.value.equals(((VersionValue)obj).value);
        }
        return this.value.equals(obj);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public JsonNode valueToJsonNode(Context context, Function<IValue, JsonNode> producer) throws PromptoError {
        return JsonNodeFactory.instance.textNode(this.toString());
    }

    @Override
    public void toJsonStream(Context context, JsonGenerator generator, Object instanceId, String fieldName, boolean withType, Map<String, byte[]> data) throws PromptoError {
        try {
            if (withType) {
                generator.writeStartObject();
                generator.writeStringField("type", VersionType.instance().getTypeName());
                generator.writeFieldName("value");
            }
            generator.writeString(this.value.toString());
            if (withType) {
                generator.writeEndObject();
            }
        }
        catch (IOException e) {
            throw new ReadWriteError(e.getMessage());
        }
    }
}

