/*
 * Decompiled with CFR 0.152.
 */
package prompto.verifier;

import java.util.concurrent.atomic.AtomicInteger;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.FieldConstant;
import prompto.compiler.IConstantOperand;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.verifier.ArgumentSizeComputer;
import prompto.verifier.BasicType;
import prompto.verifier.Klass;
import prompto.verifier.RawBytecodeStream;
import prompto.verifier.SignatureStream;
import prompto.verifier.SignatureVerifier;
import prompto.verifier.StackMapFrame;
import prompto.verifier.StackMapReader;
import prompto.verifier.StackMapTable;
import prompto.verifier.VerificationType;
import prompto.verifier.VerifierException;

public class ClassVerifier {
    static final byte BYTECODE_OFFSET = 1;
    static final byte NEW_OFFSET = 2;
    Klass _klass;
    VerificationType _this_type;

    public ClassVerifier(ClassFile classFile) {
        this._klass = new Klass(classFile);
        this._this_type = VerificationType.reference_type(this._klass.name());
    }

    public void verify() {
        this._klass.classFile.getMethods().forEach(m -> this.verifyMethod((MethodInfo)m));
    }

    public VerificationType current_type() {
        return this._this_type;
    }

    private void verifyMethod(MethodInfo m) {
        short max_stack = m.getCodeAttribute().getStackMapTable().getMaxStack();
        short max_locals = m.getCodeAttribute().getStackMapTable().getMaxLocals();
        StackMapFrame current_frame = new StackMapFrame(max_locals, max_stack, this);
        VerificationType return_type = current_frame.set_locals_from_arg(m, this.current_type());
        int stackmap_index = 0;
        int code_length = m.getCodeAttribute().getOpcodes().length;
        byte[] code_data = this.generate_code_data(m, code_length);
        int ex_min = code_length;
        int ex_max = -1;
        StackMapReader reader = new StackMapReader(this, m, code_data, code_length);
        StackMapTable stackmap_table = new StackMapTable(reader, current_frame, max_locals, max_stack, code_data, code_length);
        RawBytecodeStream bcs = new RawBytecodeStream(m.getCodeAttribute().getOpcodes());
        boolean no_control_flow = false;
        while (!bcs.is_last_bytecode()) {
            Opcode opcode = bcs.raw_next();
            int bci = bcs.bci();
            current_frame.set_offset(bci);
            current_frame.set_mark();
            stackmap_index = this.verify_stackmap_table(stackmap_index, bci, current_frame, stackmap_table, no_control_flow);
            AtomicInteger this_uninit = new AtomicInteger(0);
            switch (opcode) {
                case NOP: {
                    no_control_flow = false;
                    break;
                }
                case ACONST_NULL: {
                    current_frame.push_stack(VerificationType.null_type);
                    no_control_flow = false;
                    break;
                }
                case ICONST_M1: 
                case ICONST_0: 
                case ICONST_1: 
                case ICONST_2: 
                case ICONST_3: 
                case ICONST_4: 
                case ICONST_5: {
                    current_frame.push_stack(VerificationType.integer_type);
                    no_control_flow = false;
                    break;
                }
                case ALOAD_0: 
                case ALOAD_1: 
                case ALOAD_2: 
                case ALOAD_3: {
                    short index = (short)(opcode.ordinal() - Opcode.ALOAD_0.ordinal());
                    this.verify_aload(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case ASTORE_0: 
                case ASTORE_1: 
                case ASTORE_2: 
                case ASTORE_3: {
                    short index = (short)(opcode.ordinal() - Opcode.ASTORE_0.ordinal());
                    this.verify_astore(index, current_frame);
                    no_control_flow = false;
                    break;
                }
                case DUP: {
                    VerificationType type = current_frame.pop_stack(VerificationType.category1_check());
                    current_frame.push_stack(type);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                case I2L: {
                    VerificationType type = current_frame.pop_stack(VerificationType.integer_type);
                    current_frame.push_stack_2(VerificationType.long_type, VerificationType.long2_type);
                    no_control_flow = false;
                    break;
                }
                case IF_ACMPEQ: 
                case IF_ACMPNE: {
                    current_frame.pop_stack(VerificationType.reference_check());
                }
                case IFNULL: 
                case IFNONNULL: {
                    current_frame.pop_stack(VerificationType.reference_check());
                    int target = bcs.dest();
                    stackmap_table.check_jump_target(current_frame, target);
                    no_control_flow = false;
                    break;
                }
                case INVOKEVIRTUAL: 
                case INVOKESPECIAL: 
                case INVOKESTATIC: {
                    this.verify_invoke_instructions(opcode, bcs, code_length, current_frame, bci >= ex_min && bci < ex_max, this_uninit, return_type, stackmap_table);
                    no_control_flow = false;
                    break;
                }
                case NEW: {
                    short index = bcs.get_index_u2();
                    this.verify_cp_class_type(bci, index);
                    VerificationType new_class_type = this.cp_index_to_type(index);
                    if (!new_class_type.is_object()) {
                        throw new VerifierException("Illegal new instruction");
                    }
                    VerificationType type = VerificationType.uninitialized_type((short)bci);
                    current_frame.push_stack(type);
                    no_control_flow = false;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(opcode.name());
                }
            }
            if (bci < ex_min || bci >= ex_max) continue;
            this.verify_exception_handler_targets(bci, this_uninit, current_frame, stackmap_table);
        }
        if (!no_control_flow) {
            throw new VerifierException("Control flow falls through code end");
        }
    }

    private void verify_aload(short index, StackMapFrame current_frame) {
        VerificationType type = current_frame.get_local(index, VerificationType.reference_check());
        current_frame.push_stack(type);
    }

    private void verify_astore(short index, StackMapFrame current_frame) {
        VerificationType type = current_frame.pop_stack(VerificationType.reference_check());
        current_frame.set_local(index, type);
    }

    private VerificationType cp_index_to_type(short index) {
        IConstantOperand operand = this.constantWithIndex(index);
        if (operand instanceof ClassConstant) {
            return VerificationType.reference_type(((ClassConstant)operand).getClassName().getValue());
        }
        throw new UnsupportedOperationException(operand.getClass().getName());
    }

    private void verify_cp_class_type(int bci, short index) {
        this.verify_cp_index(bci, index);
        IConstantOperand operand = this.constantWithIndex(index);
        if (!(operand instanceof ClassConstant)) {
            throw new VerifierException("Illegal type at constant pool entry " + index);
        }
    }

    private void verify_cp_index(int bci, short index) {
        IConstantOperand operand = this.constantWithIndex(index);
        if (operand == null) {
            throw new VerifierException("Illegal type at constant pool entry " + index);
        }
    }

    private void verify_exception_handler_targets(int bci, AtomicInteger this_uninit, StackMapFrame current_frame, StackMapTable stackmap_table) {
        throw new UnsupportedOperationException();
    }

    private int verify_stackmap_table(int stackmap_index, int bci, StackMapFrame current_frame, StackMapTable stackmap_table, boolean no_control_flow) {
        if (stackmap_index < stackmap_table.get_frame_count()) {
            int this_offset = stackmap_table.get_offset(stackmap_index);
            if (no_control_flow && this_offset > bci) {
                throw new VerifierException("Expecting a stack map frame");
            }
            if (this_offset == bci) {
                stackmap_table.match_stackmap(current_frame, this_offset, stackmap_index, !no_control_flow, true, false);
                ++stackmap_index;
            } else if (this_offset < bci) {
                throw new VerifierException("Bad stack map offset " + this_offset);
            }
        } else if (no_control_flow) {
            throw new VerifierException("Expecting a stack map frame");
        }
        return stackmap_index;
    }

    private byte[] generate_code_data(MethodInfo m, int code_length) {
        byte[] code_data = new byte[code_length];
        RawBytecodeStream bcs = new RawBytecodeStream(m.getCodeAttribute().getOpcodes());
        while (!bcs.is_last_bytecode()) {
            Opcode opcode = bcs.raw_next();
            if (opcode == Opcode.ILLEGAL) {
                throw new VerifierException("Illegal opcode");
            }
            int bci = bcs.bci();
            if (opcode == Opcode.NEW) {
                code_data[bci] = 2;
                continue;
            }
            code_data[bci] = 1;
        }
        return code_data;
    }

    public int change_sig_to_verificationType(SignatureStream sig_type, VerificationType[] inference_types, int index) {
        BasicType bt = sig_type.type();
        switch (bt) {
            case T_OBJECT: 
            case T_ARRAY: {
                inference_types[index] = VerificationType.reference_type(sig_type.as_symbol());
                return 1;
            }
            case T_LONG: {
                inference_types[index] = VerificationType.long_type;
                inference_types[index + 1] = VerificationType.long2_type;
                return 2;
            }
            case T_DOUBLE: {
                inference_types[index] = VerificationType.double_type;
                inference_types[index + 1] = VerificationType.double2_type;
                return 2;
            }
            case T_INT: 
            case T_BOOLEAN: 
            case T_BYTE: 
            case T_CHAR: 
            case T_SHORT: {
                inference_types[index] = VerificationType.integer_type;
                return 1;
            }
            case T_FLOAT: {
                inference_types[index] = VerificationType.float_type;
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    void verify_invoke_instructions(Opcode opcode, RawBytecodeStream bcs, int code_length, StackMapFrame current_frame, boolean in_try_block, AtomicInteger this_uninit, VerificationType return_type, StackMapTable stackmap_table) {
        int types;
        short index = bcs.get_index_u2();
        switch (opcode) {
            case INVOKEINTERFACE: {
                types = 2048;
                break;
            }
            case INVOKEDYNAMIC: {
                types = 262144;
                break;
            }
            case INVOKESPECIAL: 
            case INVOKESTATIC: {
                types = 3072;
                break;
            }
            default: {
                types = 1024;
            }
        }
        this.verify_cp_type(bcs.bci(), index, types);
        IConstantOperand operand = this.constantWithIndex(index);
        String method_name = ((MethodConstant)operand).getMethodNameAndType().getName().getValue();
        String method_sig = ((MethodConstant)operand).getMethodNameAndType().getDescriptor().toString();
        if (!SignatureVerifier.is_valid_method_signature(method_sig)) {
            throw new VerifierException("Invalid method signature: " + method_sig);
        }
        VerificationType ref_class_type = this.cp_ref_index_to_type(index);
        int size = ArgumentSizeComputer.size(method_sig);
        VerificationType[] sig_types = new VerificationType[size];
        SignatureStream sig_stream = new SignatureStream(method_sig);
        int sig_i = 0;
        while (!sig_stream.at_return_type()) {
            sig_i += this.change_sig_to_verificationType(sig_stream, sig_types, sig_i);
            sig_stream.next();
        }
        int nargs = sig_i;
        int bci = bcs.bci();
        if (opcode == Opcode.INVOKEINTERFACE) {
            if (bcs.get_index_u1_at(bci + 3) != nargs + 1) {
                throw new VerifierException("Inconsistent args count operand in invokeinterface");
            }
            if (bcs.get_index_u1_at(bci + 4) != 0) {
                throw new VerifierException("Fourth operand byte of invokeinterface must be zero");
            }
        }
        if (opcode == Opcode.INVOKEDYNAMIC && (bcs.get_index_u1_at(bci + 3) != 0 || bcs.get_index_u1_at(bci + 4) != 0)) {
            throw new VerifierException("Third and fourth operand bytes of invokedynamic must be zero");
        }
        if (method_name.charAt(0) == '<') {
            if (opcode != Opcode.INVOKESPECIAL || !"<init>".equals(method_name)) {
                throw new VerifierException("Illegal call to internal method");
            }
        } else if (opcode == Opcode.INVOKESPECIAL && !this.is_same_or_direct_interface(this.current_class(), this.current_type(), ref_class_type) && !ref_class_type.equals(VerificationType.reference_type(this._klass.superclass_name()))) {
            boolean subtype = false;
            operand = this.constantWithIndex(index);
            boolean have_imr_indirect = operand instanceof InterfaceConstant;
            if (!this.current_class().is_anonymous()) {
                subtype = ref_class_type.is_assignable_from(this.current_type(), false, this);
            } else {
                VerificationType host_klass_type = VerificationType.reference_type(this.current_class().host_klass().name());
                subtype = ref_class_type.is_assignable_from(host_klass_type, false, this);
                have_imr_indirect = false;
            }
            if (!subtype) {
                throw new VerifierException("Bad invokespecial instruction: current class isn't assignable to reference class.");
            }
            if (have_imr_indirect) {
                throw new VerifierException("Bad invokespecial instruction: interface method reference is in an indirect superinterface.");
            }
        }
        for (int i = nargs - 1; i >= 0; --i) {
            current_frame.pop_stack(sig_types[i]);
        }
        if (opcode != Opcode.INVOKESTATIC && opcode != Opcode.INVOKEDYNAMIC) {
            if ("<init>".equals(method_name)) {
                this.verify_invoke_init(bcs, index, ref_class_type, current_frame, code_length, in_try_block, this_uninit, stackmap_table);
            } else if (opcode == Opcode.INVOKESPECIAL) {
                if (!this.current_class().is_anonymous()) {
                    current_frame.pop_stack(this.current_type());
                } else {
                    VerificationType top = current_frame.pop_stack();
                    VerificationType hosttype = VerificationType.reference_type(this.current_class().host_klass().name());
                    boolean subtype = hosttype.is_assignable_from(top, false, this);
                    if (!subtype) {
                        throw new VerifierException("Bad type on operand stack");
                    }
                }
            } else if (opcode != Opcode.INVOKEVIRTUAL) {
                if (opcode != Opcode.INVOKEINTERFACE) {
                    throw new VerifierException("Unexpected opcode encountered");
                }
                current_frame.pop_stack(ref_class_type);
            }
        }
        if (sig_stream.type() != BasicType.T_VOID) {
            if ("<init>".equals(method_name)) {
                throw new VerifierException("Return type must be void in <init> method");
            }
            VerificationType[] return_types = new VerificationType[2];
            int n = this.change_sig_to_verificationType(sig_stream, return_types, 0);
            for (int i = 0; i < n; ++i) {
                current_frame.push_stack(return_types[i]);
            }
        }
    }

    private boolean is_same_or_direct_interface(Klass current_class, VerificationType current_type, VerificationType ref_class_type) {
        throw new UnsupportedOperationException();
    }

    public Klass current_class() {
        return this._klass;
    }

    private void verify_invoke_init(RawBytecodeStream bcs, int ref_class_index, VerificationType ref_class_type, StackMapFrame current_frame, int code_length, boolean in_try_block, AtomicInteger this_uninit, StackMapTable stackmap_table) {
        int bci = bcs.bci();
        VerificationType type = current_frame.pop_stack(VerificationType.reference_check());
        if (type == VerificationType.uninitialized_this_type) {
            current_frame.initialize_object(type, this.current_type());
            this_uninit.set(1);
        } else if (type.is_uninitialized()) {
            byte[] code_data = bcs.opcodes;
            short new_offset = type.bci();
            int new_bci = bcs.bci() - bci + new_offset;
            if (new_offset > code_length - 3 || (code_data[new_bci] & 0xFF) != Opcode.NEW.opcode) {
                throw new VerifierException("Expecting new instruction");
            }
            short new_class_index = bcs.get_index_u2_at(new_bci + 1);
            this.verify_cp_class_type(bci, new_class_index);
            VerificationType new_class_type = this.cp_index_to_type(new_class_index);
            if (!new_class_type.equals(ref_class_type)) {
                throw new VerifierException("Call to wrong <init> method");
            }
            if (in_try_block) {
                this.verify_exception_handler_targets(bci, this_uninit, current_frame, stackmap_table);
            }
            current_frame.initialize_object(type, new_class_type);
        } else {
            throw new VerifierException("Bad operand type when invoking <init>");
        }
    }

    private VerificationType cp_ref_index_to_type(short index) {
        IConstantOperand operand = this.constantWithIndex(index);
        if (operand instanceof FieldConstant) {
            return this.cp_index_to_type((short)((FieldConstant)operand).getClassName().getIndexInConstantPool());
        }
        if (operand instanceof MethodConstant) {
            return this.cp_index_to_type((short)((MethodConstant)operand).getClassName().getIndexInConstantPool());
        }
        throw new VerifierException("Corrupted constant pool");
    }

    private void verify_cp_type(int bci, short index, int types) {
        this.verify_cp_index(bci, index);
        int tag = this._klass.tag_at(index);
        if ((types & 1 << tag) == 0) {
            throw new VerifierException("Illegal type at constant pool entry " + index);
        }
    }

    public IConstantOperand constantWithIndex(int index) {
        return this._klass.constantWithIndex(index);
    }
}

