/*
 * Decompiled with CFR 0.152.
 */
package prompto.verifier;

import prompto.compiler.Opcode;
import prompto.verifier.VerifierException;

public class RawBytecodeStream {
    byte[] opcodes;
    int _bci;
    int _next_bci;
    int _end_bci;

    public RawBytecodeStream(byte[] opcodes) {
        this.opcodes = opcodes;
        this._bci = 0;
        this._next_bci = 0;
        this._end_bci = opcodes.length;
    }

    public byte[] getOpcodes() {
        return this.opcodes;
    }

    public boolean is_last_bytecode() {
        return this._next_bci >= this._end_bci;
    }

    public int bci() {
        return this._bci;
    }

    public Opcode raw_next() {
        this._bci = this._next_bci;
        if (this.is_last_bytecode()) {
            throw new VerifierException("caller should check is_last_bytecode()");
        }
        if (this.opcodes[this._bci] == 196) {
            throw new UnsupportedOperationException();
        }
        Opcode code = Opcode.get(this.opcodes[this._bci]);
        int l = code.kind.length;
        if (l > 0 && this._bci + l <= this._end_bci) {
            this._next_bci += l;
            return code;
        }
        return this.raw_next_special(code);
    }

    private Opcode raw_next_special(Opcode code) {
        throw new UnsupportedOperationException();
    }

    public boolean is_wide() {
        throw new UnsupportedOperationException();
    }

    public short get_index_u2() {
        if (this.opcodes[this._bci] == 196) {
            throw new UnsupportedOperationException();
        }
        Opcode code = Opcode.get(this.opcodes[this._bci]);
        int _pos = this._bci + code.kind.width;
        if (_pos + 2 > this.opcodes.length) {
            throw new VerifierException("End of stream!");
        }
        short value = (short)(this.opcodes[_pos++] & 0xFF);
        value = (short)(value << 8);
        value = (short)(value | this.opcodes[_pos] & 0xFF);
        return value;
    }

    public short get_index_u1_at(int offset) {
        int _pos = offset;
        if (_pos >= this.opcodes.length) {
            throw new VerifierException("End of stream!");
        }
        return (short)(this.opcodes[_pos] & 0xFF);
    }

    public short get_index_u2_at(int offset) {
        int _pos = offset;
        if (_pos >= this.opcodes.length) {
            throw new VerifierException("End of stream!");
        }
        short value = (short)(this.opcodes[_pos++] & 0xFF);
        value = (short)(value << 8);
        value = (short)(value | this.opcodes[_pos] & 0xFF);
        return value;
    }

    public int dest() {
        return this.bci() + this.get_index_u2();
    }
}

