/*
 * Decompiled with CFR 0.152.
 */
package prompto.verifier;

import java.util.ArrayList;
import prompto.verifier.VerifierException;

public class Signature {
    String[] _types;

    public static Signature parse(String descriptor) {
        String ss = descriptor;
        ArrayList<String> types = new ArrayList<String>();
        String type = null;
        block7: while (ss.length() > 0) {
            switch (ss.charAt(0)) {
                case '(': {
                    ss = ss.substring(1);
                    continue block7;
                }
                case ')': {
                    if (type != null) {
                        types.add(type);
                        type = null;
                    }
                    ss = ss.substring(1);
                    continue block7;
                }
                case '[': {
                    type = type == null ? "[" : type + "[";
                    ss = ss.substring(1);
                    continue block7;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    if (type == null) {
                        types.add(ss.substring(0, 1));
                    } else {
                        types.add(type + ss.substring(0, 1));
                        type = null;
                    }
                    ss = ss.substring(1);
                    continue block7;
                }
                case 'L': {
                    int idx = ss.indexOf(59);
                    if (type == null) {
                        types.add(ss.substring(0, idx + 1));
                    } else {
                        types.add(type + ss.substring(0, idx + 1));
                        type = null;
                    }
                    ss = ss.substring(idx + 1);
                    continue block7;
                }
            }
            throw new VerifierException("Invalid signature " + descriptor);
        }
        if (type != null) {
            types.add(type);
        }
        return new Signature(types.toArray(new String[types.size()]));
    }

    public Signature(String[] types) {
        this._types = types;
    }
}

