/*
 * Decompiled with CFR 0.152.
 */
package prompto.verifier;

import java.util.Arrays;
import prompto.compiler.MethodInfo;
import prompto.verifier.ClassVerifier;
import prompto.verifier.SignatureStream;
import prompto.verifier.VerificationType;
import prompto.verifier.VerifierException;

public class StackMapFrame {
    static final byte FLAG_THIS_UNINIT = 1;
    int _offset;
    int _locals_size;
    int _stack_size;
    int _stack_mark;
    int _max_locals;
    int _max_stack;
    byte _flags;
    VerificationType[] _locals;
    VerificationType[] _stack;
    ClassVerifier _verifier;

    public StackMapFrame(int max_locals, int max_stack, ClassVerifier verifier) {
        this._offset = 0;
        this._locals_size = 0;
        this._stack_size = 0;
        this._stack_mark = 0;
        this._flags = 0;
        this._max_locals = max_locals;
        this._max_stack = max_stack;
        this._verifier = verifier;
        this._locals = new VerificationType[max_locals];
        Arrays.fill(this._locals, VerificationType.bogus_type);
        this._stack = new VerificationType[max_stack];
        Arrays.fill(this._stack, VerificationType.bogus_type);
    }

    public StackMapFrame(int offset, byte flags, int locals_size, int stack_size, int max_locals, int max_stack, VerificationType[] locals, VerificationType[] stack, ClassVerifier verifier) {
        this._offset = offset;
        this._flags = flags;
        this._locals_size = locals_size;
        this._stack_size = stack_size;
        this._stack_mark = -1;
        this._max_locals = max_locals;
        this._max_stack = max_stack;
        this._locals = locals;
        this._stack = stack;
        this._verifier = verifier;
    }

    public void set_locals_size(int locals_size) {
        this._locals_size = locals_size;
    }

    public int locals_size() {
        return this._locals_size;
    }

    private int max_locals() {
        return this._max_locals;
    }

    public void set_stack_size(int stack_size) {
        this._stack_size = this._stack_mark = stack_size;
    }

    public int stack_size() {
        return this._stack_size;
    }

    public VerificationType[] locals() {
        return this._locals;
    }

    public VerificationType[] stack() {
        return this._stack;
    }

    public void set_offset(int offset) {
        this._offset = offset;
    }

    public int offset() {
        return this._offset;
    }

    public void set_flags(byte flags) {
        this._flags = flags;
    }

    public byte flags() {
        return this._flags;
    }

    boolean flag_this_uninit() {
        return (this._flags & 1) != 0;
    }

    private ClassVerifier verifier() {
        return this._verifier;
    }

    public void set_mark() {
        if (this._stack_mark != -1) {
            for (int i = this._stack_mark - 1; i >= this._stack_size; --i) {
                this._stack[i] = VerificationType.bogus_type;
            }
        }
        this._stack_mark = this._stack_size;
    }

    public VerificationType set_locals_from_arg(MethodInfo m, VerificationType thisKlass) {
        SignatureStream ss = new SignatureStream(m.getSignature().getValue());
        int init_local_num = 0;
        if (!m.isStatic()) {
            ++init_local_num;
            if ("<init>".equals(m.getName().toString()) && !"java/lang/Object".equals(thisKlass.name())) {
                this._locals[0] = VerificationType.uninitialized_this_type;
                this._flags = (byte)(this._flags | 1);
            } else {
                this._locals[0] = thisKlass;
            }
        }
        while (!ss.at_return_type()) {
            init_local_num += this._verifier.change_sig_to_verificationType(ss, this._locals, init_local_num);
            ss.next();
        }
        this._locals_size = init_local_num;
        switch (ss.type()) {
            case T_OBJECT: 
            case T_ARRAY: {
                String sym = ss.as_symbol();
                return VerificationType.reference_type(sym);
            }
            case T_INT: {
                return VerificationType.integer_type;
            }
            case T_BYTE: {
                return VerificationType.byte_type;
            }
            case T_CHAR: {
                return VerificationType.char_type;
            }
            case T_SHORT: {
                return VerificationType.short_type;
            }
            case T_BOOLEAN: {
                return VerificationType.boolean_type;
            }
            case T_FLOAT: {
                return VerificationType.float_type;
            }
            case T_DOUBLE: {
                return VerificationType.double_type;
            }
            case T_LONG: {
                return VerificationType.long_type;
            }
            case T_VOID: {
                return VerificationType.bogus_type;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void push_stack(VerificationType type) {
        if (type.is_check()) {
            throw new VerifierException("Must be a real type");
        }
        if (this._stack_size >= this._max_stack) {
            throw new VerifierException("Operand stack overflow");
        }
        this._stack[this._stack_size++] = type;
    }

    public void push_stack_2(VerificationType type1, VerificationType type2) {
        if (!type1.is_long() && !type1.is_double()) {
            throw new VerifierException("must be long/double");
        }
        if (!type2.is_long2() && !type2.is_double2()) {
            throw new VerifierException("must be long/double_2");
        }
        if (this._stack_size >= this._max_stack - 1) {
            throw new VerifierException("Operand stack overflow");
        }
        this._stack[this._stack_size++] = type1;
        this._stack[this._stack_size++] = type2;
    }

    public void copy_locals(StackMapFrame src) {
        int len = src.locals_size() < this._locals_size ? src.locals_size() : this._locals_size;
        for (int i = 0; i < len; ++i) {
            this._locals[i] = src.locals()[i];
        }
    }

    public VerificationType pop_stack(VerificationType type) {
        VerificationType top;
        boolean subtype;
        if (this._stack_size != 0 && (subtype = type.is_assignable_from(top = this._stack[this._stack_size - 1], false, this.verifier()))) {
            --this._stack_size;
            return top;
        }
        return this.pop_stack_ex(type);
    }

    private VerificationType pop_stack_ex(VerificationType type) {
        VerificationType top;
        boolean subtype;
        if (this._stack_size <= 0) {
            throw new VerifierException("Operand stack underflow");
        }
        if (!(subtype = type.is_assignable_from(top = this._stack[--this._stack_size], false, this.verifier()))) {
            throw new VerifierException("Bad type on operand stack");
        }
        return top;
    }

    public VerificationType pop_stack() {
        throw new UnsupportedOperationException();
    }

    public void set_local(short index, VerificationType type) {
        if (type.is_check()) {
            throw new VerifierException("Must be a real type");
        }
        if (index >= this._max_locals) {
            throw new VerifierException("Local variable table overflow");
        }
        if (this._locals[index].is_double() || this._locals[index].is_long()) {
            if (index + 1 >= this._locals_size) {
                throw new VerifierException("Local variable table overflow");
            }
            this._locals[index + 1] = VerificationType.bogus_type;
        }
        if (this._locals[index].is_double2() || this._locals[index].is_long2()) {
            if (index < 1) {
                throw new VerifierException("Local variable table underflow");
            }
            this._locals[index - 1] = VerificationType.bogus_type;
        }
        this._locals[index] = type;
        if (index >= this._locals_size) {
            for (int i = this._locals_size; i < index; ++i) {
                if (this._locals[i] == VerificationType.bogus_type) continue;
                throw new VerifierException("holes must be bogus type");
            }
            this._locals_size = index + 1;
        }
    }

    public VerificationType get_local(short index, VerificationType type) {
        if (index >= this._max_locals) {
            throw new VerifierException("Local variable table overflow");
        }
        boolean subtype = type.is_assignable_from(this._locals[index], false, this.verifier());
        if (!subtype) {
            throw new VerifierException("Bad local variable type");
        }
        if (index >= this._locals_size) {
            this._locals_size = index + 1;
        }
        return this._locals[index];
    }

    public void initialize_object(VerificationType old_object, VerificationType new_object) {
        int i;
        for (i = 0; i < this._max_locals; ++i) {
            if (!this._locals[i].equals(old_object)) continue;
            this._locals[i] = new_object;
        }
        for (i = 0; i < this._stack_size; ++i) {
            if (!this._stack[i].equals(old_object)) continue;
            this._stack[i] = new_object;
        }
        if (old_object == VerificationType.uninitialized_this_type) {
            this._flags = 0;
        }
    }

    public void reset() {
        int i;
        for (i = 0; i < this._max_locals; ++i) {
            this._locals[i] = VerificationType.bogus_type;
        }
        for (i = 0; i < this._max_stack; ++i) {
            this._stack[i] = VerificationType.bogus_type;
        }
    }

    public void copy_stack(StackMapFrame src) {
        int len = src.stack_size() < this._stack_size ? src.stack_size() : this._stack_size;
        for (int i = 0; i < len; ++i) {
            this._stack[i] = src._stack[i];
        }
    }

    public boolean is_assignable_to(StackMapFrame target, boolean is_exception_handler) {
        boolean match_flags;
        if (this._max_locals != target.max_locals()) {
            throw new VerifierException("Locals size mismatch");
        }
        if (this._stack_size != target.stack_size()) {
            throw new VerifierException("Stack size mismatch");
        }
        int mismatch_loc = this.is_assignable_to(this._locals, target.locals(), target.locals_size());
        if (mismatch_loc != target.locals_size()) {
            throw new VerifierException("bad type");
        }
        mismatch_loc = this.is_assignable_to(this._stack, target.stack(), this._stack_size);
        if (mismatch_loc != this._stack_size) {
            throw new VerifierException("bad type");
        }
        boolean bl = match_flags = (this._flags | target.flags()) == target.flags();
        if (match_flags || is_exception_handler && this.has_flag_match_exception(target)) {
            return true;
        }
        throw new VerifierException("bad flags");
    }

    int is_assignable_to(VerificationType[] from, VerificationType[] to, int len) {
        int i = 0;
        for (i = 0; i < len && to[i].is_assignable_from(from[i], false, this.verifier()); ++i) {
        }
        return i;
    }

    boolean has_flag_match_exception(StackMapFrame target) {
        int i;
        if (this.max_locals() != target.max_locals() || this.stack_size() != target.stack_size()) {
            throw new VerifierException("StackMap sizes must match");
        }
        VerificationType top = VerificationType.top_type;
        VerificationType this_type = this.verifier().current_type();
        if (!this.flag_this_uninit() || target.flags() != 0) {
            return false;
        }
        for (i = 0; i < target.locals_size(); ++i) {
            if (this.locals()[i] != this_type || target.locals()[i] == top) continue;
            return false;
        }
        for (i = 0; i < target.stack_size(); ++i) {
            if (this.stack()[i] != this_type || target.stack()[i] == top) continue;
            return false;
        }
        return true;
    }
}

