/*
 * Decompiled with CFR 0.152.
 */
package prompto.verifier;

import java.util.concurrent.atomic.AtomicInteger;
import prompto.compiler.ClassConstant;
import prompto.compiler.IConstantOperand;
import prompto.compiler.MethodInfo;
import prompto.verifier.ByteReader;
import prompto.verifier.ClassVerifier;
import prompto.verifier.StackMapFrame;
import prompto.verifier.VerificationType;
import prompto.verifier.VerifierException;

public class StackMapReader {
    ClassVerifier _verifier;
    ByteReader _stream;
    byte[] _code_data;
    int _code_length;
    int _frame_count;

    public StackMapReader(ClassVerifier verifier, MethodInfo method, byte[] code_data, int code_length) {
        this._verifier = verifier;
        this._code_data = code_data;
        this._code_length = code_length;
        if (method.getCodeAttribute().getStackMapTable() != null) {
            byte[] stackmap_data = method.getCodeAttribute().getStackMapTable().getData();
            this._stream = new ByteReader(stackmap_data, 6);
            this._frame_count = this._stream.get_u2();
        } else {
            this._frame_count = 0;
        }
    }

    public int get_frame_count() {
        return this._frame_count;
    }

    public StackMapFrame next(StackMapFrame pre_frame, boolean first, int max_locals, int max_stack) {
        Object locals = null;
        int frame_type = this._stream.get_u1();
        if (frame_type < 64) {
            int offset;
            if (first) {
                offset = frame_type;
                if (pre_frame.locals_size() > 0) {
                    locals = new VerificationType[pre_frame.locals_size()];
                }
            } else {
                offset = pre_frame.offset() + frame_type + 1;
                locals = pre_frame.locals();
            }
            StackMapFrame frame = new StackMapFrame(offset, pre_frame.flags(), pre_frame.locals_size(), 0, max_locals, max_stack, (VerificationType[])locals, null, this._verifier);
            if (first && locals != null) {
                frame.copy_locals(pre_frame);
            }
            return frame;
        }
        if (frame_type < 128) {
            int offset;
            if (first) {
                offset = frame_type - 64;
                if (pre_frame.locals_size() > 0) {
                    locals = new VerificationType[pre_frame.locals_size()];
                }
            } else {
                offset = pre_frame.offset() + frame_type - 63;
                locals = pre_frame.locals();
            }
            VerificationType[] stack = new VerificationType[2];
            int stack_size = 1;
            stack[0] = this.parse_verification_type(null);
            if (stack[0].is_category2()) {
                stack[1] = stack[0].to_category2_2nd();
                stack_size = 2;
            }
            this.check_verification_type_array_size(stack_size, max_stack);
            StackMapFrame frame = new StackMapFrame(offset, pre_frame.flags(), pre_frame.locals_size(), stack_size, max_locals, max_stack, (VerificationType[])locals, stack, this._verifier);
            if (first && locals != null) {
                frame.copy_locals(pre_frame);
            }
            return frame;
        }
        int offset_delta = this._stream.get_u2();
        if (frame_type < 247) {
            throw new VerifierException("reserved frame type");
        }
        if (frame_type == 247) {
            int offset;
            if (first) {
                offset = offset_delta;
                if (pre_frame.locals_size() > 0) {
                    locals = new VerificationType[pre_frame.locals_size()];
                }
            } else {
                offset = pre_frame.offset() + offset_delta + 1;
                locals = pre_frame.locals();
            }
            VerificationType[] stack = new VerificationType[2];
            int stack_size = 1;
            stack[0] = this.parse_verification_type(null);
            if (stack[0].is_category2()) {
                stack[1] = stack[0].to_category2_2nd();
                stack_size = 2;
            }
            this.check_verification_type_array_size(stack_size, max_stack);
            StackMapFrame frame = new StackMapFrame(offset, pre_frame.flags(), pre_frame.locals_size(), stack_size, max_locals, max_stack, (VerificationType[])locals, stack, this._verifier);
            if (first && locals != null) {
                frame.copy_locals(pre_frame);
            }
            return frame;
        }
        if (frame_type <= 251) {
            int offset;
            locals = pre_frame.locals();
            int length = pre_frame.locals_size();
            int chops = 251 - frame_type;
            int new_length = length;
            byte flags = pre_frame.flags();
            if (chops != 0) {
                new_length = this.chop((VerificationType[])locals, length, chops);
                this.check_verification_type_array_size(new_length, max_locals);
                flags = 0;
                for (int i = 0; i < new_length; ++i) {
                    if (!locals[i].is_uninitialized_this()) continue;
                    flags = (byte)(flags | 1);
                    break;
                }
            }
            if (first) {
                offset = offset_delta;
                locals = new_length > 0 ? new VerificationType[new_length] : null;
            } else {
                offset = pre_frame.offset() + offset_delta + 1;
            }
            StackMapFrame frame = new StackMapFrame(offset, flags, new_length, 0, max_locals, max_stack, (VerificationType[])locals, null, this._verifier);
            if (first && locals != null) {
                frame.copy_locals(pre_frame);
            }
            return frame;
        }
        if (frame_type < 255) {
            int i;
            int appends = frame_type - 251;
            int real_length = pre_frame.locals_size();
            int new_length = real_length + appends * 2;
            locals = new VerificationType[new_length];
            VerificationType[] pre_locals = pre_frame.locals();
            for (i = 0; i < pre_frame.locals_size(); ++i) {
                locals[i] = pre_locals[i];
            }
            AtomicInteger flags = new AtomicInteger(pre_frame.flags());
            for (i = 0; i < appends; ++i) {
                locals[real_length] = this.parse_verification_type(flags);
                if (locals[real_length].is_category2()) {
                    locals[real_length + 1] = locals[real_length].to_category2_2nd();
                    ++real_length;
                }
                ++real_length;
            }
            this.check_verification_type_array_size(real_length, max_locals);
            int offset = first ? offset_delta : pre_frame.offset() + offset_delta + 1;
            StackMapFrame frame = new StackMapFrame(offset, flags.byteValue(), real_length, 0, max_locals, max_stack, (VerificationType[])locals, null, this._verifier);
            return frame;
        }
        if (frame_type == 255) {
            int i;
            AtomicInteger flags = new AtomicInteger(0);
            int locals_size = this._stream.get_u2();
            int real_locals_size = 0;
            if (locals_size > 0) {
                locals = new VerificationType[locals_size * 2];
            }
            for (i = 0; i < locals_size; ++i) {
                locals[real_locals_size] = this.parse_verification_type(flags);
                if (locals[real_locals_size].is_category2()) {
                    locals[real_locals_size + 1] = locals[real_locals_size].to_category2_2nd();
                    ++real_locals_size;
                }
                ++real_locals_size;
            }
            this.check_verification_type_array_size(real_locals_size, max_locals);
            int stack_size = this._stream.get_u2();
            int real_stack_size = 0;
            VerificationType[] stack = null;
            if (stack_size > 0) {
                stack = new VerificationType[stack_size * 2];
            }
            for (i = 0; i < stack_size; ++i) {
                stack[real_stack_size] = this.parse_verification_type(null);
                if (stack[real_stack_size].is_category2()) {
                    stack[real_stack_size + 1] = stack[real_stack_size].to_category2_2nd();
                    ++real_stack_size;
                }
                ++real_stack_size;
            }
            this.check_verification_type_array_size(real_stack_size, max_stack);
            int offset = first ? offset_delta : pre_frame.offset() + offset_delta + 1;
            StackMapFrame frame = new StackMapFrame(offset, flags.byteValue(), real_locals_size, real_stack_size, max_locals, max_stack, (VerificationType[])locals, stack, this._verifier);
            return frame;
        }
        throw new VerifierException("reserved frame type");
    }

    private int chop(VerificationType[] locals, int length, int chops) {
        throw new UnsupportedOperationException();
    }

    private void check_verification_type_array_size(int size, int max_size) {
        if (size < 0 || size > max_size) {
            throw new VerifierException("StackMapTable format error: bad type array size");
        }
    }

    private VerificationType parse_verification_type(AtomicInteger flags) {
        int tag = this._stream.get_u1();
        if (tag < VerificationType.ITEM_UninitializedThis) {
            return VerificationType.from_tag(tag);
        }
        if (tag == VerificationType.ITEM_Object) {
            int class_index = this._stream.get_u2();
            IConstantOperand operand = this._verifier.constantWithIndex(class_index);
            if (!(operand instanceof ClassConstant)) {
                throw new VerifierException("bad class index");
            }
            return VerificationType.reference_type(((ClassConstant)operand).getClassName().getValue());
        }
        if (tag == VerificationType.ITEM_UninitializedThis) {
            if (flags != null) {
                flags.set(flags.byteValue() | 1);
            }
            return VerificationType.uninitialized_this_type;
        }
        if (tag == VerificationType.ITEM_Uninitialized) {
            int offset = this._stream.get_u2();
            if (offset >= this._code_length || this._code_data[offset] != 2) {
                throw new VerifierException("StackMapTable format error: bad offset for Uninitialized");
            }
            return VerificationType.uninitialized_type((short)offset);
        }
        throw new VerifierException("bad verification type");
    }

    public void check_end() {
        if (this._stream != null && !this._stream.at_end()) {
            throw new VerifierException("wrong attribute size");
        }
    }
}

