/*
 * Decompiled with CFR 0.152.
 */
package prompto.verifier;

import prompto.verifier.StackMapFrame;
import prompto.verifier.StackMapReader;
import prompto.verifier.VerifierException;

public class StackMapTable {
    static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    static final int SAME_EXTENDED = 251;
    static final int FULL = 255;
    int _code_length;
    int _frame_count;
    StackMapFrame[] _frame_array;

    public StackMapTable(StackMapReader reader, StackMapFrame init_frame, int max_locals, int max_stack, byte[] code_data, int code_length) {
        this._code_length = code_length;
        this._frame_count = reader.get_frame_count();
        if (this._frame_count > 0) {
            this._frame_array = new StackMapFrame[this._frame_count];
            StackMapFrame pre_frame = init_frame;
            for (int i = 0; i < this._frame_count; ++i) {
                StackMapFrame frame;
                this._frame_array[i] = frame = reader.next(pre_frame, i == 0, max_locals, max_stack);
                int offset = frame.offset();
                if (offset >= code_length || code_data[offset] == 0) {
                    throw new VerifierException("StackMapTable error: bad offset");
                }
                pre_frame = frame;
            }
        }
        reader.check_end();
    }

    public int get_frame_count() {
        return this._frame_count;
    }

    boolean match_stackmap(StackMapFrame frame, int target, boolean match, boolean update, boolean handler) {
        int index = this.get_index_from_offset(target);
        return this.match_stackmap(frame, target, index, match, update, handler);
    }

    public boolean match_stackmap(StackMapFrame frame, int target, int frame_index, boolean match, boolean update, boolean handler) {
        if (frame_index < 0 || frame_index >= this._frame_count) {
            throw new VerifierException("Expecting a stackmap frame at branch target " + target);
        }
        StackMapFrame stackmap_frame = this._frame_array[frame_index];
        boolean result = true;
        if (match && !frame.is_assignable_to(stackmap_frame, handler)) {
            throw new VerifierException("Instruction type does not match stack map");
        }
        if (update) {
            int lsize = stackmap_frame.locals_size();
            int ssize = stackmap_frame.stack_size();
            if (frame.locals_size() > lsize || frame.stack_size() > ssize) {
                frame.reset();
            }
            frame.set_locals_size(lsize);
            frame.copy_locals(stackmap_frame);
            frame.set_stack_size(ssize);
            frame.copy_stack(stackmap_frame);
            frame.set_flags(stackmap_frame.flags());
        }
        return result;
    }

    private int get_index_from_offset(int offset) {
        int i;
        for (i = 0; i < this._frame_count; ++i) {
            if (this._frame_array[i].offset() != offset) continue;
            return i;
        }
        return i;
    }

    public int get_offset(int stackmap_index) {
        return this._frame_array[stackmap_index].offset();
    }

    public void check_jump_target(StackMapFrame frame, int target) {
        boolean match = this.match_stackmap(frame, target, true, false, false);
        if (!match || target < 0 || target >= this._code_length) {
            throw new VerifierException("Inconsistent stackmap frames at branch target " + target);
        }
    }
}

