/*
 * Decompiled with CFR 0.152.
 */
package prompto.verifier;

import prompto.compiler.IVerifierEntry;
import prompto.verifier.ClassVerifier;
import prompto.verifier.VerifierException;

public class VerificationType {
    static final int BitsPerByte = 8;
    static final int TypeMask = 3;
    static final int Reference = 0;
    static final int Primitive = 1;
    static final int Uninitialized = 2;
    static final int TypeQuery = 3;
    static final int ReferenceFlag = 0;
    static final int Category1Flag = 1;
    static final int Category2Flag = 2;
    static final int Category2_2ndFlag = 4;
    static final int Null = 0;
    static final int Category1 = 257;
    static final int Category2 = 513;
    static final int Category2_2nd = 1025;
    static final int ITEM_Bogus = -1;
    static final int ITEM_Top = IVerifierEntry.VerifierType.ITEM_Top.ordinal();
    static final int ITEM_Integer = IVerifierEntry.VerifierType.ITEM_Integer.ordinal();
    static final int ITEM_Float = IVerifierEntry.VerifierType.ITEM_Float.ordinal();
    static final int ITEM_Double = IVerifierEntry.VerifierType.ITEM_Double.ordinal();
    static final int ITEM_Long = IVerifierEntry.VerifierType.ITEM_Long.ordinal();
    static final int ITEM_Null = IVerifierEntry.VerifierType.ITEM_Null.ordinal();
    static final int ITEM_UninitializedThis = IVerifierEntry.VerifierType.ITEM_UninitializedThis.ordinal();
    static final int ITEM_Object = IVerifierEntry.VerifierType.ITEM_Object.ordinal();
    static final int ITEM_Uninitialized = IVerifierEntry.VerifierType.ITEM_Uninitialized.ordinal();
    static final int ITEM_Boolean = 9;
    static final int ITEM_Byte = 10;
    static final int ITEM_Short = 11;
    static final int ITEM_Char = 12;
    static final int ITEM_Long_2nd = 13;
    static final int ITEM_Double_2nd = 14;
    static final int Bogus = -65279;
    static final int Boolean = 590081;
    static final int Byte = 655617;
    static final int Short = 721153;
    static final int Char = 786689;
    static final int Integer = ITEM_Integer << 16 | 0x101;
    static final int Float = ITEM_Float << 16 | 0x101;
    static final int Long = ITEM_Long << 16 | 0x201;
    static final int Double = ITEM_Double << 16 | 0x201;
    static final int Long_2nd = 852993;
    static final int Double_2nd = 918529;
    static final int BciMask = 0xFFFF00;
    static final short BciForThis = -1;
    static final int ReferenceQuery = 3;
    static final int Category1Query = 259;
    static final int Category2Query = 515;
    static final int Category2_2ndQuery = 1027;
    static final VerificationType bogus_type;
    static final VerificationType top_type;
    static final VerificationType null_type;
    static final VerificationType boolean_type;
    static final VerificationType char_type;
    static final VerificationType byte_type;
    static final VerificationType short_type;
    static final VerificationType integer_type;
    static final VerificationType long_type;
    static final VerificationType long2_type;
    static final VerificationType float_type;
    static final VerificationType double_type;
    static final VerificationType double2_type;
    static final VerificationType uninitialized_this_type;
    int _data;
    String _name;

    static VerificationType reference_type(String name) {
        return new VerificationType(name);
    }

    static VerificationType uninitialized_type(short bci) {
        return new VerificationType(bci << 8 | 2);
    }

    public static VerificationType from_tag(int tag) {
        if (tag == ITEM_Top) {
            return bogus_type;
        }
        if (tag == ITEM_Integer) {
            return integer_type;
        }
        if (tag == ITEM_Float) {
            return float_type;
        }
        if (tag == ITEM_Double) {
            return double_type;
        }
        if (tag == ITEM_Long) {
            return long_type;
        }
        if (tag == ITEM_Null) {
            return null_type;
        }
        throw new VerifierException("Should never get there!");
    }

    static VerificationType reference_check() {
        return new VerificationType(3);
    }

    static VerificationType category1_check() {
        return new VerificationType(259);
    }

    static VerificationType category2_check() {
        return new VerificationType(515);
    }

    static VerificationType category2_2nd_check() {
        return new VerificationType(1027);
    }

    public VerificationType to_category2_2nd() {
        throw new UnsupportedOperationException();
    }

    public boolean is_uninitialized_this() {
        throw new UnsupportedOperationException();
    }

    public VerificationType(int data) {
        this._data = data;
    }

    public VerificationType(String name) {
        this._data = -4;
        this._name = name;
    }

    public boolean equals(Object obj) {
        return obj instanceof VerificationType && this.equals((VerificationType)obj);
    }

    public String toString() {
        if (this._name != null) {
            return this._name;
        }
        if (this.is_bogus()) {
            return "bogus";
        }
        int data = this._data >> 16 & 0xFFFF;
        IVerifierEntry.VerifierType type = IVerifierEntry.VerifierType.values()[data];
        return type.name();
    }

    public boolean equals(VerificationType t) {
        return this.is_reference() ? t.is_reference() && !this.is_null() && !t.is_null() && this.name() == t.name() : this._data == t._data;
    }

    public String name() {
        return this._name;
    }

    boolean is_category1() {
        if (this.is_check()) {
            throw new VerifierException("Must not be a check type (wrong value returned)");
        }
        return (this._data & 0x101) != 1;
    }

    public boolean is_category2() {
        return (this._data & 0x201) == 513;
    }

    boolean is_category2_2nd() {
        return (this._data & 0x401) == 1025;
    }

    public boolean is_object() {
        return this.is_reference() && !this.is_null() && this.name().length() >= 1 && this.name().charAt(0) != '[';
    }

    boolean is_array() {
        return this.is_reference() && !this.is_null() && this.name().length() >= 1 && this.name().charAt(0) == '[';
    }

    boolean is_integer() {
        return this._data == Integer;
    }

    public boolean is_long() {
        return this._data == Long;
    }

    public boolean is_long2() {
        return this._data == 852993;
    }

    public boolean is_double() {
        return this._data == Double;
    }

    public boolean is_double2() {
        return this._data == 918529;
    }

    private boolean is_null() {
        return this._data == 0;
    }

    private boolean is_reference() {
        return (this._data & 3) == 0;
    }

    public boolean is_check() {
        return (this._data & 3) == 3;
    }

    private boolean is_bogus() {
        return this._data == -65279;
    }

    boolean is_uninitialized() {
        return (this._data & 2) == 2;
    }

    VerificationType get_component(ClassVerifier verifier) {
        if (!this.is_array() || this.name().length() < 2) {
            throw new VerifierException("Must be a valid array");
        }
        switch (this.name().charAt(1)) {
            case 'Z': {
                return new VerificationType(590081);
            }
            case 'B': {
                return new VerificationType(655617);
            }
            case 'C': {
                return new VerificationType(786689);
            }
            case 'S': {
                return new VerificationType(721153);
            }
            case 'I': {
                return new VerificationType(Integer);
            }
            case 'J': {
                return new VerificationType(Long);
            }
            case 'F': {
                return new VerificationType(Float);
            }
            case 'D': {
                return new VerificationType(Double);
            }
            case '[': {
                String component = this.name().substring(1);
                return VerificationType.reference_type(component);
            }
            case 'L': {
                String component = this.name().substring(1, this.name().length() - 1);
                return VerificationType.reference_type(component);
            }
        }
        throw new VerifierException("Invalid signature");
    }

    public boolean is_assignable_from(VerificationType from, boolean from_field_is_protected, ClassVerifier verifier) {
        if (this.equals(from) || this.is_bogus()) {
            return true;
        }
        switch (this._data) {
            case 259: {
                return from.is_category1();
            }
            case 515: {
                return from.is_category2();
            }
            case 1027: {
                return from.is_category2_2nd();
            }
            case 3: {
                return from.is_reference() || from.is_uninitialized();
            }
            case 590081: 
            case 655617: 
            case 721153: 
            case 786689: {
                return from.is_integer();
            }
        }
        if (this.is_reference() && from.is_reference()) {
            return this.is_reference_assignable_from(from, from_field_is_protected, verifier);
        }
        return false;
    }

    boolean is_reference_assignable_from(VerificationType from, boolean from_field_is_protected, ClassVerifier verifier) {
        if (from.is_null()) {
            return true;
        }
        if (this.is_null()) {
            return false;
        }
        if (this.name() == from.name()) {
            return true;
        }
        if (this.is_object()) {
            if ("java/lang/Object".equals(this.name())) {
                return true;
            }
            if (verifier.current_class().is_interface() && (!from_field_is_protected || "java/lang/Object".equals(from.name()))) {
                return true;
            }
            if (from.is_object()) {
                return true;
            }
        } else if (this.is_array() && from.is_array()) {
            VerificationType comp_this = this.get_component(verifier);
            VerificationType comp_from = from.get_component(verifier);
            if (!comp_this.is_bogus() && !comp_from.is_bogus()) {
                return comp_this.is_assignable_from(comp_from, from_field_is_protected, verifier);
            }
        }
        return false;
    }

    public short bci() {
        if (!this.is_uninitialized()) {
            throw new VerifierException("Must be uninitialized type");
        }
        return (short)((this._data & 0xFFFF00) >> 8);
    }

    static {
        top_type = bogus_type = new VerificationType(-65279);
        null_type = new VerificationType(0);
        boolean_type = new VerificationType(590081);
        char_type = new VerificationType(786689);
        byte_type = new VerificationType(655617);
        short_type = new VerificationType(721153);
        integer_type = new VerificationType(Integer);
        long_type = new VerificationType(Long);
        long2_type = new VerificationType(852993);
        float_type = new VerificationType(Float);
        double_type = new VerificationType(Double);
        double2_type = new VerificationType(918529);
        uninitialized_this_type = VerificationType.uninitialized_type((short)-1);
    }
}

