/*
 * Decompiled with CFR 0.152.
 */
package prompto.security;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import prompto.security.MockTrustManager;
import prompto.utils.Instance;
import prompto.utils.ManualTests;

@Category(value={ManualTests.class})
public class TestServerCertificates {
    static String CERTS_DIR = "/Users/ericvergnaud/Prompto/certificates/JavaCertificates/";
    static Instance<String> password = new Instance();
    static Supplier<String> PASSWORD = () -> {
        if (password.get() == null) {
            try {
                System.out.println("Enter keystore password:");
                String entered = new BufferedReader(new InputStreamReader(System.in)).readLine();
                password.set((Object)entered);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return (String)password.get();
    };

    @Before
    public void before() throws Exception {
        MockTrustManager.install();
    }

    @After
    public void after() {
        MockTrustManager.restore();
    }

    @Test
    public void testLoadCertificate() throws Throwable {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = this.loadKeyStore(CERTS_DIR + "keystore.jks");
        kmf.init(ks, PASSWORD.get().toCharArray());
    }

    @Test
    public void testRealCertificates() throws Throwable {
        Server server = new Server();
        ServerConnector connector = this.createConnector(server);
        server.setConnectors(new Connector[]{connector});
        server.setHandler(this.createHandler());
        Thread thread = new Thread(() -> {
            try {
                server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.start();
        while (!server.isStarted()) {
            Thread.sleep(10L);
        }
        server.join();
    }

    private ServerConnector createConnector(Server server) throws Exception {
        SslConnectionFactory ssl = this.createSSLFactory();
        HttpConnectionFactory https = this.createHttpsFactory();
        ServerConnector sc = new ServerConnector(server, new ConnectionFactory[]{ssl, https});
        sc.setPort(8443);
        return sc;
    }

    private Handler createHandler() {
        return new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.setContentType("text/plain;charset=ascii");
                response.setStatus(200);
                baseRequest.setHandled(true);
                response.getWriter().println("Hello");
            }
        };
    }

    private HttpConnectionFactory createHttpsFactory() {
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return new HttpConnectionFactory(https);
    }

    private SslConnectionFactory createSSLFactory() throws Exception {
        SslContextFactory factory = new SslContextFactory();
        KeyStore ks = this.loadKeyStore(CERTS_DIR + "keystore.jks");
        factory.setKeyStore(ks);
        factory.setKeyStorePassword(PASSWORD.get());
        ks = this.loadKeyStore(CERTS_DIR + "truststore.jks");
        factory.setTrustStore(ks);
        factory.setTrustStorePassword(PASSWORD.get());
        return new SslConnectionFactory(factory, "http/1.1");
    }

    private KeyStore loadKeyStore(String filePath) throws Exception {
        try (FileInputStream input = new FileInputStream(filePath);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(input, null);
            KeyStore keyStore = ks;
            return keyStore;
        }
    }
}

