/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import prompto.error.PromptoError;
import prompto.remoting.RemoteArgument;
import prompto.remoting.RemoteArgumentList;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.server.AppServer;
import prompto.server.BaseServerTest;
import prompto.type.IType;
import prompto.type.TextType;
import prompto.value.IValue;
import prompto.value.TextValue;

public class TestConnect
extends BaseServerTest {
    @Test
    public void testStartAndStop() throws Throwable {
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
        AppServer.start(null);
        Assert.assertTrue((boolean)AppServer.isStarted());
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
    }

    @Ignore
    @Test
    public void testControlExit() throws Throwable {
        URL url = new URL("http://localhost:" + this.port + "/ws/control/exit");
        URLConnection cnx = url.openConnection();
        InputStream input = cnx.getInputStream();
        input.close();
        Assert.assertFalse((boolean)AppServer.isStarted());
        Thread.sleep(1000L);
    }

    @Test
    public void testControlClearContext() throws Throwable {
        ApplicationContext.get().findAttribute("name");
        Assert.assertFalse((boolean)ApplicationContext.get().isEmpty());
        URL url = new URL("http://localhost:" + this.port + "/ws/control/clear-context");
        URLConnection cnx = url.openConnection();
        InputStream input = cnx.getInputStream();
        input.close();
        Assert.assertTrue((boolean)ApplicationContext.get().isEmpty());
    }

    @Test
    public void testResource() throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/js/lib/require.js");
        URLConnection cnx = url.openConnection();
        InputStream input = cnx.getInputStream();
        Assert.assertNotNull((Object)input);
        input.close();
    }

    @Test
    public void testServiceNoParam() throws Exception {
        Context context = Context.newGlobalsContext();
        RemoteArgumentList params = this.createParameterList(new Object[0]);
        URL url = new URL("http://localhost:" + this.port + "/ws/run/getAllAttributes?params=" + params.toURLEncodedString(context));
        URLConnection cnx = url.openConnection();
        InputStream input = cnx.getInputStream();
        Assert.assertNotNull((Object)input);
        JsonNode json = this.parseJSON(input);
        Assert.assertNotNull((Object)json);
        input.close();
        System.out.println(json.toString());
    }

    @Test
    public void testService1TextParam() throws Exception {
        Context context = Context.newGlobalsContext();
        RemoteArgumentList params = this.createParameterList("name", TextType.instance(), new TextValue("id"));
        URL url = new URL("http://localhost:" + this.port + "/ws/run/findAttribute?params=" + params.toURLEncodedString(context));
        URLConnection cnx = url.openConnection();
        InputStream input = cnx.getInputStream();
        Assert.assertNotNull((Object)input);
        JsonNode json = this.parseJSON(input);
        Assert.assertNotNull((Object)json);
        input.close();
        System.out.println(json.toString());
    }

    private RemoteArgumentList createParameterList(Object ... params) throws IOException, PromptoError {
        RemoteArgumentList list = new RemoteArgumentList();
        for (int i = 0; i < params.length; i += 3) {
            RemoteArgument param = new RemoteArgument();
            param.setName(params[i].toString());
            param.setType((IType)params[i + 1]);
            param.setValue((IValue)params[i + 2]);
            list.add((Object)param);
        }
        return list;
    }

    private JsonNode parseJSON(InputStream input) throws Exception {
        JsonParser parser = new ObjectMapper().getFactory().createParser(input);
        return (JsonNode)parser.readValueAsTree();
    }
}

