/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.security.MockTrustManager;
import prompto.server.AppServer;
import prompto.server.BaseServerTest;

public class TestConnectSSL
extends BaseServerTest {
    @Before
    public void before() throws Exception {
        MockTrustManager.install();
    }

    @After
    public void after() {
        MockTrustManager.restore();
    }

    public TestConnectSSL() {
        this.ssl = true;
    }

    @Test
    public void testStartAndStop() throws Throwable {
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
        AppServer.start(null);
        Assert.assertTrue((boolean)AppServer.isStarted());
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
    }

    @Test
    public void testResource() throws Exception {
        URL url = new URL("https://localhost:" + this.port + "/ws/control/version");
        try (InputStream input = url.openStream();
             InputStreamReader reader = new InputStreamReader(input);
             BufferedReader buffered = new BufferedReader(reader);){
            Assert.assertEquals((Object)"1.0.0", (Object)buffered.readLine());
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail();
        }
    }
}

