/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoTime;
import prompto.server.BaseServerTest;
import prompto.server.DataServlet;
import prompto.store.IStorable;
import prompto.store.IStore;
import prompto.store.memory.MemStore;

public class TestDataServlet
extends BaseServerTest {
    IStore store;

    @Before
    public void before() {
        this.store = new MemStore();
        DataServlet.setStores(Collections.singletonMap("DATA", this.store));
    }

    @Test
    public void canFetchAllOnEmptyStore() throws Exception {
        JsonNode node = this.runQuery("fetch all");
        Assert.assertTrue((boolean)node.get("error").isNull());
        Assert.assertEquals((long)0L, (long)node.get("data").get("totalCount").asLong());
    }

    @Test
    public void canFetchAllWithAny() throws Exception {
        IStorable doc = this.store.newStorable(Collections.singletonList("Any"), id -> {});
        doc.setData("name", (Object)"John");
        this.store.store(doc);
        JsonNode node = this.runQuery("fetch all");
        Assert.assertTrue((boolean)node.get("error").isNull());
        node = node.get("data");
        Assert.assertEquals((long)1L, (long)node.get("totalCount").asLong());
    }

    @Test
    public void canFetchAllWithCategory() throws Exception {
        IStorable doc = this.store.newStorable(Collections.singletonList("MyCategory"), id -> {});
        doc.setData("text", (Object)"someName");
        doc.setData("integer", (Object)987654321L);
        doc.setData("decimal", (Object)9.87654321654E8);
        doc.setData("date", (Object)new PromptoDate(2017, 3, 14));
        doc.setData("time", (Object)new PromptoTime(16, 32, 45, 11));
        doc.setData("datetime", (Object)PromptoDateTime.parse((String)"2017-03-14T16:32:45.011+08:00"));
        this.store.store(doc);
        JsonNode node = this.runQuery("fetch all");
        Assert.assertTrue((boolean)node.get("error").isNull());
        node = node.get("data");
        Assert.assertEquals((long)1L, (long)node.get("totalCount").asLong());
        node = node.get("value").get(0);
        Assert.assertEquals((Object)"MyCategory", (Object)node.get("type").asText());
        node = node.get("value");
        Assert.assertEquals((Object)"someName", (Object)node.get("text").asText());
        Assert.assertEquals((long)987654321L, (long)node.get("integer").asLong());
        Assert.assertEquals((double)9.87654321654E8, (double)node.get("decimal").asDouble(), (double)0.01);
        Assert.assertEquals((Object)new PromptoDate(2017, 3, 14), (Object)PromptoDate.parse((String)node.get("date").get("value").asText()));
        Assert.assertEquals((Object)new PromptoTime(16, 32, 45, 11), (Object)PromptoTime.parse((String)node.get("time").get("value").asText()));
        Assert.assertEquals((Object)PromptoDateTime.parse((String)"2017-03-14T16:32:45.011+08:00"), (Object)PromptoDateTime.parse((String)node.get("datetime").get("value").asText()));
    }

    private JsonNode runQuery(String query) throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/ws/data/fetch?store=DATA&query=" + URLEncoder.encode(query, "UTF-8"));
        try (InputStream input = url.openStream();){
            JsonNode jsonNode = new ObjectMapper().readTree(input);
            return jsonNode;
        }
    }
}

