/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.config.TempDirectories;
import prompto.runtime.Mode;
import prompto.utils.SocketUtils;

public class TestSocketUtils {
    @Before
    public void __before__() throws Throwable {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
    }

    @Test
    public void testThatAValidPortIsReturned() throws IOException {
        int port = SocketUtils.findAvailablePortInRange((int)8080, (int)9090);
        Assert.assertTrue((port >= 8080 && port <= 9090 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThatInvalidRangeThrows() throws IOException {
        int port = SocketUtils.findAvailablePortInRange((int)8080, (int)8079);
        Assert.assertTrue((port >= 8080 && port <= 9090 ? 1 : 0) != 0);
    }

    @Test(expected=IOException.class)
    public void testThatTrulyNoPortThrows() throws IOException {
        try (ServerSocket s = new ServerSocket(0);){
            s.setReuseAddress(true);
            SocketUtils.findAvailablePortInRange((int)s.getLocalPort(), (int)s.getLocalPort());
        }
    }

    @Test
    public void testThatReturnedPortIsStillValid() throws IOException {
        int port = SocketUtils.findAvailablePortInRange((int)8080, (int)9090);
        try (ServerSocket s = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));){
            s.setReuseAddress(false);
        }
    }
}

