/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.util.Map;
import java.util.function.Supplier;
import prompto.config.HttpConfiguration;
import prompto.config.IConfigurationReader;
import prompto.config.IHttpConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.RuntimeConfiguration;

public class ServerConfiguration
extends RuntimeConfiguration
implements IServerConfiguration {
    Supplier<IHttpConfiguration> httpConfiguration = () -> this.readHttpConfiguration();
    Supplier<String> serverAboutToStartMethod = () -> reader.getString("serverAboutToStart");
    Supplier<String> webSiteRoot = () -> reader.getString("webSiteRoot");

    public ServerConfiguration(IConfigurationReader reader, Map<String, String> arguments) {
        super(reader, arguments);
    }

    private IHttpConfiguration readHttpConfiguration() {
        IConfigurationReader child = this.reader.getObject("http");
        return child == null ? null : new HttpConfiguration(child);
    }

    @Override
    public IHttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration.get();
    }

    @Override
    public String getServerAboutToStartMethod() {
        return this.serverAboutToStartMethod.get();
    }

    @Override
    public String getWebSiteRoot() {
        return this.webSiteRoot.get();
    }

    @Override
    public <T extends IServerConfiguration> T withServerAboutToStartMethod(String method) {
        this.serverAboutToStartMethod = () -> method;
        return (T)this;
    }

    @Override
    public <T extends IServerConfiguration> T withHttpConfiguration(IHttpConfiguration config) {
        this.httpConfiguration = () -> config;
        return (T)this;
    }

    public YamlMapping toYaml() throws YamlException {
        String value;
        YamlMapping yaml = super.toYaml();
        IHttpConfiguration http = this.httpConfiguration.get();
        if (http != null) {
            yaml.setEntry("http", (YamlElement)http.toYaml());
        }
        if ((value = this.serverAboutToStartMethod.get()) != null) {
            yaml.setEntry("serverAboutToStart", value);
        }
        if ((value = this.webSiteRoot.get()) != null) {
            yaml.setEntry("webSiteRoot", value);
        }
        return yaml;
    }
}

