/*
 * Decompiled with CFR 0.152.
 */
package prompto.config.auth;

import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.esotericsoftware.yamlbeans.document.YamlSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import prompto.code.ICodeStore;
import prompto.code.QueryableCodeStore;
import prompto.config.IConfigurationReader;
import prompto.config.StoredRecordConfigurationReader;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.method.IAuthenticationMethodConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.runtime.Mode;
import prompto.security.auth.method.BasicAuthenticationMethodFactory;
import prompto.security.auth.method.FormAuthenticationMethodFactory;
import prompto.security.auth.method.IAuthenticationMethodFactory;
import prompto.security.auth.source.IAuthenticationSourceFactory;
import prompto.security.auth.source.PasswordIsUserNameAuthenticationSourceFactory;
import prompto.security.auth.source.StoredPasswordDigestAuthenticationSourceFactory;
import prompto.store.IStore;
import prompto.utils.Logger;

public class CodeStoreAuthenticationConfiguration
extends IAuthenticationConfiguration.Inline {
    static final Logger logger = new Logger();
    IConfigurationReader source;
    StoredRecordConfigurationReader reader;
    Supplier<IAuthenticationSourceConfiguration> storedAuthenticationSourceConfiguration;
    Supplier<IAuthenticationMethodConfiguration> storedAuthenticationMethodConfiguration;
    Supplier<Collection<String>> storedWhiteList;

    public CodeStoreAuthenticationConfiguration(IConfigurationReader source) {
        this();
        this.source = source;
    }

    public CodeStoreAuthenticationConfiguration(StoredRecordConfigurationReader reader) {
        this();
        this.reader = reader.getObject("authenticationSettings");
    }

    private CodeStoreAuthenticationConfiguration() {
        this.authenticationSourceConfiguration = () -> this.readAuthenticationSourceConfiguration(null);
        this.authenticationMethodConfiguration = () -> this.readAuthenticationMethodConfiguration();
        this.whiteList = () -> this.readWhiteList();
    }

    private IStore locateStore() {
        ICodeStore codeStore = (ICodeStore)ICodeStore.instance.get();
        if (!(codeStore instanceof QueryableCodeStore)) {
            logger.error(() -> "No code store to fetch config!");
            return null;
        }
        IStore store = ((QueryableCodeStore)codeStore).getStore();
        if (store == null) {
            logger.error(() -> "No underlying store to fetch config!");
            return null;
        }
        return store;
    }

    private boolean loadReader() {
        if (this.reader != null) {
            return true;
        }
        if (this.source == null) {
            return false;
        }
        IStore store = this.locateStore();
        if (store == null) {
            return false;
        }
        String dbId = this.source.getString("dbId");
        if (dbId == null) {
            logger.error(() -> "No dbId to fetch config!");
            return false;
        }
        StoredRecordConfigurationReader app = new StoredRecordConfigurationReader(store, (Object)dbId);
        this.reader = app.getObject("authenticationSettings");
        return this.reader != null;
    }

    public YamlMapping toYaml(Mode mode) throws Throwable {
        if (!this.isEnabled(mode)) {
            return null;
        }
        YamlMapping settings = new YamlMapping();
        IAuthenticationMethodConfiguration method = this.readAuthenticationMethodConfiguration();
        IAuthenticationSourceConfiguration source = this.readAuthenticationSourceConfiguration(mode);
        if (method != null && source != null) {
            YamlMapping yaml = method.getAuthenticationMethodFactory().toYaml();
            settings.setEntry("method", (YamlElement)yaml);
            yaml = source.getAuthenticationSourceFactory().toYaml();
            settings.setEntry("source", (YamlElement)yaml);
            YamlSequence list = new YamlSequence();
            for (String w : this.fetchWhiteList()) {
                list.addElement(w);
            }
            settings.setEntry("whiteList", (YamlElement)list);
            return settings;
        }
        return null;
    }

    public boolean isEnabled(Mode runtimeMode) {
        if (runtimeMode != Mode.DEVELOPMENT) {
            return true;
        }
        if (!this.loadReader()) {
            return false;
        }
        Boolean skipAuthInDev = this.reader.getBooleanOrDefault("skipAuthInDev", Boolean.FALSE.booleanValue());
        return skipAuthInDev == false;
    }

    private IAuthenticationMethodConfiguration readAuthenticationMethodConfiguration() {
        if (this.storedAuthenticationMethodConfiguration != null) {
            return this.storedAuthenticationMethodConfiguration.get();
        }
        IAuthenticationMethodConfiguration config = this.fetchAuthenticationMethodConfiguration();
        this.storedAuthenticationMethodConfiguration = () -> config;
        return config;
    }

    private IAuthenticationMethodConfiguration fetchAuthenticationMethodConfiguration() {
        try {
            if (!this.loadReader()) {
                return null;
            }
            StoredRecordConfigurationReader method = this.reader.getObject("authenticationMethod");
            if (method == null) {
                return null;
            }
            String category = method.readCategory();
            if (category == null) {
                return null;
            }
            String factoryName = AuthenticationMethod.valueOf(category).getFactoryName();
            IAuthenticationMethodFactory factory = IAuthenticationMethodFactory.newFactory(factoryName);
            IAuthenticationMethodConfiguration config = factory.newConfiguration((IConfigurationReader)method);
            factory.setConfiguration(config);
            return () -> factory;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public IAuthenticationSourceConfiguration readAuthenticationSourceConfiguration(Mode runtimeMode) {
        if (this.storedAuthenticationSourceConfiguration != null) {
            return this.storedAuthenticationSourceConfiguration.get();
        }
        IAuthenticationSourceConfiguration config = this.fetchAuthenticationSourceConfiguration(runtimeMode);
        this.storedAuthenticationSourceConfiguration = () -> config;
        return config;
    }

    private IAuthenticationSourceConfiguration fetchAuthenticationSourceConfiguration(Mode runtimeMode) {
        try {
            if (!this.loadReader()) {
                return null;
            }
            Boolean useTestSourceInDev = this.reader.getBooleanOrDefault("useTestSourceInDev", Boolean.FALSE.booleanValue());
            if (useTestSourceInDev.booleanValue()) {
                IAuthenticationSourceConfiguration config = () -> new PasswordIsUserNameAuthenticationSourceFactory();
                this.storedAuthenticationSourceConfiguration = () -> config;
                return config;
            }
            StoredRecordConfigurationReader source = this.reader.getObject("authenticationSource");
            if (source == null) {
                return null;
            }
            String category = source.readCategory();
            if (category == null) {
                return null;
            }
            String factoryName = AuthenticationSource.valueOf(category).getFactoryName();
            if (factoryName == null) {
                return null;
            }
            IAuthenticationSourceFactory factory = IAuthenticationSourceFactory.newFactory(factoryName);
            IAuthenticationSourceConfiguration config = factory.newConfiguration((IConfigurationReader)source);
            factory.setConfiguration(config);
            return () -> factory;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Collection<String> readWhiteList() {
        if (this.storedWhiteList != null) {
            return this.storedWhiteList.get();
        }
        Collection<String> whiteList = this.fetchWhiteList();
        this.storedWhiteList = () -> whiteList;
        return whiteList;
    }

    private Collection<String> fetchWhiteList() {
        Collection whiteList;
        if (!this.loadReader()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.alsoUsesDefaultWhiteList()) {
            result.addAll(DEFAULT_WHITE_LIST);
        }
        if ((whiteList = this.reader.getArray("whiteList")) != null) {
            result.addAll(whiteList);
        }
        return result;
    }

    private boolean alsoUsesDefaultWhiteList() {
        return this.reader.getBooleanOrDefault("useDefaultWhiteList", Boolean.FALSE.booleanValue());
    }

    static enum AuthenticationSource {
        DataStoreAuthenticationSource(StoredPasswordDigestAuthenticationSourceFactory.class.getName()),
        PasswordIsLoginAuthenticationSource(PasswordIsUserNameAuthenticationSourceFactory.class.getName());

        private String factoryName;

        private AuthenticationSource(String factoryName) {
            this.factoryName = factoryName;
        }

        public String getFactoryName() {
            return this.factoryName;
        }
    }

    static enum AuthenticationMethod {
        NoAuthenticationMethod(null),
        BasicAuthenticationMethod(BasicAuthenticationMethodFactory.class.getName()),
        FormAuthenticationMethod(FormAuthenticationMethodFactory.class.getName());

        private String factoryName;

        private AuthenticationMethod(String factoryName) {
            this.factoryName = factoryName;
        }

        public String getFactoryName() {
            return this.factoryName;
        }
    }
}

