/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.server.DataServlet;
import prompto.store.AttributeInfo;
import prompto.store.Family;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.utils.StringUtils;

public class JsonRecordsWriter {
    JsonGenerator generator;
    Function<String, AttributeInfo> fetcher;
    IStore store;
    boolean loadChildren;
    Map<String, JsonWriter> writers = new HashMap<String, JsonWriter>();
    static Map<Family, JsonWriter> familyWriters = Stream.of(JsonRecordsWriter.newEntry(Family.BOOLEAN, (g, o) -> g.writeBoolean(((Boolean)o).booleanValue())), JsonRecordsWriter.newEntry(Family.INTEGER, (g, o) -> g.writeNumber(((Number)o).longValue())), JsonRecordsWriter.newEntry(Family.DECIMAL, (g, o) -> g.writeNumber(((Number)o).doubleValue())), JsonRecordsWriter.newEntry(Family.TEXT, (g, o) -> g.writeString((String)o)), JsonRecordsWriter.newEntry(Family.UUID, JsonRecordsWriter::writeUuid), JsonRecordsWriter.newEntry(Family.DATE, JsonRecordsWriter::writePromptoDate), JsonRecordsWriter.newEntry(Family.TIME, JsonRecordsWriter::writePromptoTime), JsonRecordsWriter.newEntry(Family.DATETIME, JsonRecordsWriter::writePromptoDateTime), JsonRecordsWriter.newEntry(Family.VERSION, JsonRecordsWriter::writePromptoVersion), JsonRecordsWriter.newEntry(Family.ENUMERATED, (g, o) -> g.writeString((String)o)), JsonRecordsWriter.newEntry(Family.CATEGORY, (g, o) -> g.writeString("<instance>")), JsonRecordsWriter.newEntry(Family.RESOURCE, (g, o) -> g.writeString("<instance>"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    static Map<Class<?>, JsonWriter> classWriters = Stream.of(JsonRecordsWriter.newEntry(Boolean.class, (g, o) -> g.writeBoolean(((Boolean)o).booleanValue())), JsonRecordsWriter.newEntry(Long.class, (g, o) -> g.writeNumber(((Number)o).longValue())), JsonRecordsWriter.newEntry(Double.class, (g, o) -> g.writeNumber(((Number)o).doubleValue())), JsonRecordsWriter.newEntry(String.class, (g, o) -> g.writeString((String)o)), JsonRecordsWriter.newEntry(UUID.class, JsonRecordsWriter::writeUuid), JsonRecordsWriter.newEntry(PromptoDate.class, JsonRecordsWriter::writePromptoDate), JsonRecordsWriter.newEntry(PromptoTime.class, JsonRecordsWriter::writePromptoTime), JsonRecordsWriter.newEntry(PromptoDateTime.class, JsonRecordsWriter::writePromptoDateTime), JsonRecordsWriter.newEntry(PromptoVersion.class, JsonRecordsWriter::writePromptoVersion), JsonRecordsWriter.newEntry(PromptoBinary.class, JsonRecordsWriter::writeBinary)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    public JsonRecordsWriter(OutputStream output, Function<String, AttributeInfo> fetcher, IStore store, boolean loadChildren) throws IOException {
        this.generator = new JsonFactory().createGenerator(output);
        this.fetcher = fetcher;
        this.store = store;
        this.loadChildren = loadChildren;
    }

    public void writeRecords(Object fetched) throws IOException {
        this.writeJsonListRecords(fetched);
    }

    public void writeRecord(IStored fetched) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeNullField("error");
        if (fetched == null) {
            this.generator.writeNullField("data");
        } else {
            this.generator.writeFieldName("data");
            this.writeJsonRecord(fetched);
        }
        this.generator.writeEndObject();
        this.generator.flush();
        this.generator.close();
    }

    private void writeJsonListRecords(Object fetched) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeNullField("error");
        this.generator.writeFieldName("data");
        this.writeJsonList(fetched);
        this.generator.writeEndObject();
        this.generator.flush();
        this.generator.close();
    }

    private void writeJsonList(Object fetched) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeFieldName("type");
        this.generator.writeString("Any[]");
        if (fetched == null) {
            this.generator.writeFieldName("count");
            this.generator.writeNumber(0);
            this.generator.writeFieldName("totalCount");
            this.generator.writeNumber(0);
            this.generator.writeNullField("value");
        } else if (fetched instanceof IStored) {
            this.generator.writeFieldName("count");
            this.generator.writeNumber(1);
            this.generator.writeFieldName("totalCount");
            this.generator.writeNumber(1);
            this.generator.writeFieldName("value");
            this.generator.writeStartArray();
            this.writeJsonRecord((IStored)fetched);
            this.generator.writeEndArray();
        } else if (fetched instanceof IStoredIterable) {
            this.generator.writeFieldName("count");
            this.generator.writeNumber(((IStoredIterable)fetched).count());
            this.generator.writeFieldName("totalCount");
            this.generator.writeNumber(((IStoredIterable)fetched).totalCount());
            this.generator.writeFieldName("value");
            this.generator.writeStartArray();
            for (IStored stored : (IStoredIterable)fetched) {
                this.writeJsonRecord(stored);
            }
            this.generator.writeEndArray();
        } else {
            throw new InvalidParameterException("Type not supported: " + fetched.getClass().getName());
        }
    }

    private void writeJsonRecord(IStored stored) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeFieldName("type");
        this.generator.writeString(DataServlet.readCategory(stored));
        this.generator.writeFieldName("value");
        this.generator.writeStartObject();
        this.generator.writeFieldName("dbId");
        Object rawDbId = stored.getDbId();
        this.writeJsonRaw(rawDbId);
        String dbId = rawDbId.toString();
        for (String name : stored.getNames()) {
            if ("category".equals(name) || "dbId".equals(name)) continue;
            this.writeJsonField(name, stored.getData(name), dbId);
        }
        this.generator.writeEndObject();
        this.generator.writeEndObject();
    }

    private void writeJsonRaw(Object value) throws IOException {
        JsonWriter writer = JsonRecordsWriter.writerForValue(value);
        if (writer != null) {
            writer.accept(this.generator, value);
        } else {
            try {
                this.generator.writeObject(value);
            }
            catch (IllegalStateException e) {
                this.generator.writeString(value.toString());
            }
        }
    }

    private void writeJsonField(String name, Object value, String dbId) throws IOException {
        this.generator.writeFieldName(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            JsonWriter writer = this.writerForName(name, dbId);
            if (writer == null) {
                writer = JsonRecordsWriter.writerForValue(value);
            }
            writer.accept(this.generator, value);
        }
    }

    private JsonWriter writerForName(String name, String dbId) throws IOException {
        JsonWriter writer = this.writers.get(name);
        if (writer != null) {
            return writer;
        }
        AttributeInfo info = this.fetcher.apply(name);
        if (info == null) {
            return null;
        }
        Family family = info.getFamily();
        if (family == Family.IMAGE || family == Family.BLOB) {
            return (g, o) -> JsonRecordsWriter.writeBinary(g, o, family, name, dbId);
        }
        writer = this.loadChildren && (family == Family.CATEGORY || family == Family.RESOURCE) ? this::writeChild : familyWriters.get(family);
        if (writer == null) {
            throw new IOException("No writer for " + info.getFamily().name());
        }
        if (info.isCollection()) {
            writer = JsonRecordsWriter.listJsonWriterFor(writer);
        }
        this.writers.put(name, writer);
        return writer;
    }

    static <T> Map.Entry<T, JsonWriter> newEntry(T key, JsonWriter writer) {
        return new AbstractMap.SimpleEntry<T, JsonWriter>(key, writer);
    }

    static JsonWriter writerForValue(Object value) throws IOException {
        if (value == null) {
            return (g, o) -> g.writeNull();
        }
        JsonWriter writer = classWriters.get(value.getClass());
        if (writer == null && Iterable.class.isAssignableFrom(value.getClass())) {
            writer = classWriters.get(Iterable.class);
        }
        if (writer == null && IStored.class.isAssignableFrom(value.getClass())) {
            writer = classWriters.get(IStored.class);
        }
        if (writer == null) {
            writer = (g, o) -> g.writeString("<unsupported>");
        }
        return writer;
    }

    private void writeChild(JsonGenerator generator, Object value) throws IOException {
        IStored stored = this.store.fetchUnique(value);
        if (stored == null) {
            generator.writeNull();
        } else {
            this.writeJsonRecord(stored);
        }
    }

    private static void writeUuid(JsonGenerator generator, Object value) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("type");
        generator.writeString("Uuid");
        generator.writeFieldName("value");
        generator.writeString(value.toString());
        generator.writeEndObject();
    }

    private static void writePromptoDate(JsonGenerator generator, Object value) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("type");
        generator.writeString("Date");
        generator.writeFieldName("value");
        generator.writeString(value.toString());
        generator.writeEndObject();
    }

    private static void writePromptoTime(JsonGenerator generator, Object value) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("type");
        generator.writeString("Time");
        generator.writeFieldName("value");
        generator.writeString(value.toString());
        generator.writeEndObject();
    }

    private static void writePromptoDateTime(JsonGenerator generator, Object value) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("type");
        generator.writeString("DateTime");
        generator.writeFieldName("value");
        generator.writeString(value.toString());
        generator.writeEndObject();
    }

    private static void writePromptoVersion(JsonGenerator generator, Object value) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("type");
        generator.writeString("Version");
        generator.writeFieldName("value");
        generator.writeString(value.toString());
        generator.writeEndObject();
    }

    private static void writeBinary(JsonGenerator generator, Object value) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("type");
        generator.writeString("Binary");
        generator.writeFieldName("value");
        generator.writeString("<binary>");
        generator.writeEndObject();
    }

    private static void writeBinary(JsonGenerator generator, Object value, Family family, String fieldName, String dbId) throws IOException {
        if (value instanceof PromptoBinary) {
            generator.writeStartObject();
            generator.writeStringField("type", StringUtils.capitalizeFirst((String)family.name()));
            generator.writeFieldName("value");
            generator.writeStartObject();
            generator.writeStringField("mimeType", ((PromptoBinary)value).getMimeType());
            generator.writeStringField("url", "/ws/bin/data?dbId=" + dbId + "&attribute=" + fieldName);
            generator.writeEndObject();
            generator.writeEndObject();
        } else {
            JsonRecordsWriter.writeBinary(generator, value);
        }
    }

    static JsonWriter listJsonWriterFor(JsonWriter writer) {
        return (g, o) -> {
            if (o == null) {
                g.writeNull();
            } else {
                g.writeStartArray();
                for (Object i : (Collection)o) {
                    writer.accept(g, i);
                }
                g.writeEndArray();
            }
        };
    }

    private static interface JsonWriter {
        public void accept(JsonGenerator var1, Object var2) throws IOException;
    }
}

