/*
 * Decompiled with CFR 0.152.
 */
package prompto.store.mongo;

import java.net.URL;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import prompto.code.ICodeStore;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IStandaloneConfiguration;
import prompto.config.TempDirectories;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.runtime.Interpreter;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.mongo.BaseMongoTest;
import prompto.store.mongo.MongoStore;

public class TestCollections
extends BaseMongoTest {
    @Before
    public void before() throws Throwable {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
        MongoStore dataStore = this.createStore("APPS");
        ICodeStore codeStore = Standalone.bootstrapCodeStore((IStore)dataStore, (IRuntimeConfiguration)this.newStandaloneConfig());
        dataStore = this.createStore("DATA");
        DataStore.setInstance((IStore)dataStore);
        Standalone.main((IStandaloneConfiguration)this.newStandaloneConfig(), (ICodeStore)codeStore, (IStore)dataStore);
    }

    private IStandaloneConfiguration newStandaloneConfig() {
        return (IStandaloneConfiguration)new IStandaloneConfiguration.Inline().withMainMethod("onStart").withRuntimeLibs(() -> {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.addAll(Libraries.getPromptoLibraries(Libraries.class));
            urls.add(Thread.currentThread().getContextClassLoader().getResource("mongoEmbeddedCollection.poc"));
            return urls;
        }).withApplicationVersion(PromptoVersion.parse((String)"1.0.0")).withApplicationName("test").withLoadRuntime(true).withRuntimeMode(Mode.UNITTEST);
    }

    @Test
    public void testTheProblem() throws Throwable {
        Interpreter.interpretMethod((Context)ApplicationContext.get(), (Identifier)new Identifier("theProblem"), (String)"");
    }
}

