/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.mongodb.client.MongoCollection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.UUID;
import org.bson.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.config.IHttpConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.TempDirectories;
import prompto.config.auth.CodeStoreAuthenticationConfigurationFactory;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.method.IAuthenticationMethodConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.security.auth.method.FormAuthenticationMethodFactory;
import prompto.security.auth.source.PasswordIsUserNameAuthenticationSourceFactory;
import prompto.server.AppServer;
import prompto.store.IStore;
import prompto.store.mongo.BaseMongoTest;
import prompto.store.mongo.MongoUtils;

public class TestStoredRecordAuthenticationConfiguration
extends BaseMongoTest {
    @Before
    public void before() throws Exception {
        TempDirectories.create();
        this.createStore("APPS");
        Standalone.bootstrapCodeStore((IStore)this.store, (IRuntimeConfiguration)this.newRuntimeConfig());
    }

    private IRuntimeConfiguration newRuntimeConfig() {
        return new IRuntimeConfiguration.Inline().withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class})).withApplicationVersion(PromptoVersion.parse((String)"1.0.0")).withApplicationName("test").withLoadRuntime(false).withRuntimeMode(Mode.UNITTEST);
    }

    @Test
    public void storedAuthenticationSettingsCanBeRead() throws Exception {
        Object dbId = this.storeSettings();
        File file = this.generateYamlConfig(dbId);
        String[] args = new String[]{"-yamlConfigFile", file.getAbsolutePath()};
        IServerConfiguration config = AppServer.loadConfiguration((String[])args);
        Assert.assertNotNull((Object)config);
        IHttpConfiguration http = config.getHttpConfiguration();
        Assert.assertNotNull((Object)http);
        IAuthenticationConfiguration auth = http.getAuthenticationConfiguration();
        Assert.assertNotNull((Object)auth);
        IAuthenticationMethodConfiguration method = auth.getAuthenticationMethodConfiguration();
        Assert.assertTrue((boolean)(method.getAuthenticationMethodFactory() instanceof FormAuthenticationMethodFactory));
        IAuthenticationSourceConfiguration source = auth.getAuthenticationSourceConfiguration();
        Assert.assertTrue((boolean)(source.getAuthenticationSourceFactory() instanceof PasswordIsUserNameAuthenticationSourceFactory));
    }

    private File generateYamlConfig(Object dbId) throws Exception {
        YamlMapping auth = new YamlMapping();
        auth.setEntry("factory", CodeStoreAuthenticationConfigurationFactory.class.getName());
        auth.setEntry("dbId", dbId.toString());
        YamlMapping http = new YamlMapping();
        http.setEntry("authentication", (YamlElement)auth);
        YamlMapping settings = new YamlMapping();
        settings.setEntry("http", (YamlElement)http);
        File file = File.createTempFile("settings-", ".yml");
        try (FileWriter writer = new FileWriter(file);){
            YamlConfig config = new YamlConfig();
            config.writeConfig.setWriteClassname(YamlConfig.WriteClassName.NEVER);
            config.writeConfig.setAutoAnchor(false);
            YamlWriter yaml = new YamlWriter((Writer)writer, config);
            yaml.write((Object)settings);
        }
        return file;
    }

    private Object storeSettings() throws IOException {
        MongoCollection collection = this.db.getCollection("instances");
        Document root = MongoUtils.readResource((String)"config/app.json");
        String ref = (String)root.get((Object)"authenticationSettings");
        Document settings = MongoUtils.readResource((String)ref);
        ref = (String)settings.get((Object)"authenticationMethod");
        Document method = MongoUtils.readResource((String)ref);
        method.put("_id", (Object)UUID.randomUUID());
        collection.insertOne((Object)method);
        settings.put("authenticationMethod", method.get((Object)"_id"));
        ref = (String)settings.get((Object)"authenticationSource");
        Document source = MongoUtils.readResource((String)ref);
        source.put("_id", (Object)UUID.randomUUID());
        collection.insertOne((Object)source);
        settings.put("authenticationSource", source.get((Object)"_id"));
        settings.put("_id", (Object)UUID.randomUUID());
        collection.insertOne((Object)settings);
        root.put("authenticationSettings", settings.get((Object)"_id"));
        root.put("_id", (Object)UUID.randomUUID());
        collection.insertOne((Object)root);
        return root.get((Object)"_id");
    }
}

