/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.junit.Assert;
import org.junit.Test;
import prompto.server.AppServer;
import prompto.server.BaseServerTest;
import prompto.utils.SSLUtils;

public class TestConnectSSL
extends BaseServerTest {
    public TestConnectSSL() {
        this.ssl = true;
    }

    @Test
    public void testStartAndStop() throws Throwable {
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
        AppServer.start(null);
        Assert.assertTrue((boolean)AppServer.isStarted());
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResource() throws Exception {
        URL url = new URL("https://localhost:" + this.port + "/ws/control/version");
        HttpsURLConnection cnx = (HttpsURLConnection)url.openConnection();
        SSLUtils.trustAllCertificates((HttpsURLConnection)cnx);
        InputStream input = cnx.getInputStream();
        try (InputStreamReader reader = new InputStreamReader(input);
             BufferedReader buffered = new BufferedReader(reader);){
            Assert.assertEquals((Object)"1.0.0", (Object)buffered.readLine());
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail();
        }
        finally {
            cnx.disconnect();
        }
    }
}

