/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import prompto.config.IConfigurationReader;
import prompto.config.IKeyStoreConfiguration;
import prompto.config.IKeyStoreFactoryConfiguration;
import prompto.config.ISecretKeyConfiguration;

public class KeyStoreConfiguration
implements IKeyStoreConfiguration {
    IConfigurationReader reader;

    public KeyStoreConfiguration(IConfigurationReader reader) {
        this.reader = reader;
    }

    @Override
    public IKeyStoreFactoryConfiguration getKeyStoreFactoryConfiguration() {
        return this.reader.readKeyStoreFactoryConfiguration("provider");
    }

    @Override
    public ISecretKeyConfiguration getSecretKeyConfiguration() {
        return this.reader.readSecretKeyConfiguration("secretKey");
    }

    @Override
    public YamlMapping toYaml() throws YamlException {
        ISecretKeyConfiguration secretKey;
        YamlMapping yaml = new YamlMapping();
        IKeyStoreFactoryConfiguration provider = this.getKeyStoreFactoryConfiguration();
        if (provider != null) {
            yaml.setEntry("provider", (YamlElement)provider.toYaml());
        }
        if ((secretKey = this.getSecretKeyConfiguration()) != null) {
            yaml.setEntry("secretKey", (YamlElement)secretKey.toYaml());
        }
        return yaml;
    }
}

