/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.debug.IDebugRequest;
import prompto.debug.IDebugResponse;
import prompto.debug.IDebugger;
import prompto.debug.Serializer;
import prompto.server.CleverServlet;

public class DebugRequestServlet
extends CleverServlet {
    IDebugger debugger;

    public void setDebugger(IDebugger debugger) {
        this.debugger = debugger;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String contentType = req.getContentType();
            if (contentType.startsWith("application/json")) {
                this.doPostJson(req, resp);
            } else {
                resp.sendError(415);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            resp.setStatus(500);
            this.writeJSONError(t.getMessage(), resp.getOutputStream());
        }
    }

    private void doPostJson(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        IDebugRequest request = Serializer.readDebugRequest((InputStream)req.getInputStream());
        IDebugResponse response = request.execute(this.debugger);
        resp.setContentType("application/json");
        Serializer.writeDebugResponse((OutputStream)resp.getOutputStream(), (IDebugResponse)response);
    }
}

